#! /bin/sh


echo "#####################"
echo "# System Parameters #"
echo "#####################"
echo ""
echo "hostname: " `hostname`
echo "hostname -f: " `hostname -f`
echo "hostname -i: " `hostname -i`
echo "uname -a: " `uname -a`
echo ""
echo ""

echo "df -k"
echo "====="
df -lk
echo ""
echo ""

echo "ipcs -l"
echo "======="
ipcs -l
echo ""
echo ""

echo "netstat -r"
echo "=========="
netstat -r
echo ""
echo ""

echo "cat /proc/cpuinfo"
echo "================="
if [ -e /proc/cpuinfo ]; then
    cat /proc/cpuinfo
else
    echo "/proc/cpuinfo does not exist"
fi
echo ""
echo ""

echo "cat /proc/meminfo"
echo "================="
if [ -e /proc/meminfo ]; then
    cat /proc/meminfo
else
    echo "/proc/meminfo does not exist"
fi
echo ""
echo ""

echo "cat /proc/sys/kernel/shmmax"
echo "==========================="
if [ -e /proc/sys/kernel/shmmax ]; then
    cat /proc/sys/kernel/shmmax
else
    echo "/proc/sys/kernel/shmmax does not exist"
fi
echo ""
echo ""

echo "cat /proc/pci"
echo "============="
if [ -e /proc/pci ]; then
    cat /proc/pci
else
    echo "/proc/pci does not exist"
fi
echo ""
echo ""

echo "cat /proc/modules"
echo "================="
if [ -e /proc/modules ]; then
    cat /proc/modules
else
    echo "/proc/modules does not exist"
fi
echo ""
echo ""

echo "cat /proc/interrupts"
echo "===================="
if [ -e /proc/interrupts ]; then
    cat /proc/interrupts
else
    echo "/proc/interrupts does not exist"
fi
echo ""
echo ""

echo "cat /proc/stat"
echo "=============="
if [ -e /proc/stat ]; then
    cat /proc/stat
else
    echo "/proc/stat does not exist"
fi
echo ""
echo ""

echo "/sbin/lspci -v"
echo "==============="
if [ -x /sbin/lspci ]; then
/sbin/lspci -v
else
    echo "/sbin/lspci does not exist"
fi
echo ""
echo ""

echo "dmesg | tail -n 30"
echo "=================="
if [ -x /bin/dmesg ]; then
dmesg | tail -n 30
else
    echo "/bin/dmesg does not exist"
fi
echo ""
echo ""

echo "gcc -v"
echo "======"
gcc -v
echo ""
echo ""


echo "######################"
echo "# Optional Libraries #"
echo "######################"
echo ""
if [ -x gtk-config ]; then
echo "gtk-config --version: " `gtk-config --version`
echo "gtk-config --prefix: " `gtk-config --prefix`
else
echo "gtk-config: not found"
fi
echo ""
if [ -x imlib-config ]; then
echo "imlib-config --version: " `imlib-config --version`
echo "imlib-config --prefix: " `imlib-config --prefix`
else
echo "imlib-config: not found"
fi
echo ""
if [ -x gtk-config ]; then
echo "xml-config --version: " `xml-config --version`
echo "xml-config --prefix: " `xml-config --prefix`
else
echo "xml-config: not found"
fi
echo ""
if [ -x pkg-config ]; then
echo "pkg-config --modversion gtk+-2.0: " `pkg-config --modversion gtk+-2.0`
echo "pkg-config --cflags gtk+-2.0: " `pkg-config --cflags gtk+-2.0`
echo ""
echo "pkg-config --modversion libxml-2.0: " `pkg-config --modversion libxml-2.0`
echo "pkg-config --cflags libxml-2.0: " `pkg-config --cflags libxml-2.0`
else
echo "pkg-config: not found"
fi
echo ""
#echo "which perl: " `which perl`
#echo ""
#echo "which wish: " `which wish`
#echo ""
#echo "which javac: " `which javac`
#echo "which java: " `which java`
#echo ""
echo "root-config --version: " `root-config --version`
echo "root-config --prefix: " `root-config --prefix`
echo ""
echo ""


echo "###########################"
echo "# Environmental Variables #"
echo "###########################"
echo ""
echo "KINOKO_ROOT: $KINOKO_ROOT"
echo "KINOKO_XTERM: KINOKO_XTERM"
echo "KINOKO_RSH: $KINOKO_RSH"
echo "KINOKO_CONTROL_PORT_BASE: $KINOKO_CONTROL_PORT_BASE"
echo "KINOKO_DATASTREAM_PORT_BASE: $KINOKO_DATASTREAM_PORT_BASE"
echo "KINOKO_SHELL_PORT_BASE: $KINOKO_SHELL_PORT_BASE"
echo "KCOM_PATH: $KCOM_PATH"
echo "KORB_PROJECT_PATH: $KORB_PROJECT_PATH"
echo "PATH: $PATH"
echo ""
echo ""


if [ -z $KINOKO_ROOT ]; then
    echo "Environmental variable KINOKO_ROOT is not defined.";
    exit;
fi


echo "############"
echo "# ksysinfo #"
echo "############"
echo ""
$KINOKO_ROOT/bin/ksysinfo
echo ""
echo ""


echo "#################"
echo "# kinoko-config #"
echo "#################"
echo ""
$KINOKO_ROOT/bin/kinoko-config
echo ""
echo ""


echo "################"
echo "# kinoko-lsmod #"
echo "################"
echo ""
$KINOKO_ROOT/bin/kinoko-lsmod
echo ""
echo ""


echo "#################"
echo "# make showconf #"
echo "#################"
echo ""
cd $KINOKO_ROOT/src
make showconf
cd -
echo ""
echo ""
