/* KinokoBoard.cc */
/* Created by Enomoto Sanshiro on 29 October 2001. */
/* Last updated by Enomoto Sanshiro on 29 October 2001. */


#include <iostream>
#include <fstream>
#include <string>
#include "KinokoCanvasTextArea.hh"
#include "KinokoBoard.hh"

using namespace std;



TKinokoBoard::TKinokoBoard(TKinokoShellConnector* ShellConnector)
: TKinokoShell(ShellConnector)
{
    _TextArea = 0;
    _IsScrollingFrozen = false;
}

TKinokoBoard::~TKinokoBoard()
{
}

void TKinokoBoard::Initialize(TKinokoCanvasTextArea* TextArea)
{
    _TextArea = TextArea;
    _TextArea->SetEditable(false);
}

int TKinokoBoard::ProcessSystemCommand(const string& Command, istream& InputStream) {
    int Result = 0;

    if (Command == ".write") {
	Result = ProcessWriteCommand(InputStream);
    }
    else if (Command == ".writeStatus") {
	Result = ProcessWriteStatusCommand(InputStream);
    }
    else if (Command == ".set") {
	Result = ProcessSetCommand(InputStream);
    }
    else if (Command == ".clear") {
	Result = ProcessClearCommand(InputStream);
    }
    else if (Command == ".save") {
	Result = ProcessSaveCommand(InputStream);
    }
    else {
	Result = TKinokoShell::ProcessSystemCommand(Command, InputStream);
    }

    return Result;
}

int TKinokoBoard::ProcessWriteCommand(istream& InputStream)
{
    int Result = 0;

    string Line;
    if (getline(InputStream >> ws, Line)) {
	_TextArea->PutLine(Line + '\n');
	Result = 1;
    }

    return Result;
}

int TKinokoBoard::ProcessWriteStatusCommand(istream& InputStream)
{
    string Line;
    if (getline(InputStream >> ws, Line)) {
	WriteStatusMessage(Line);
    }
    else {
	WriteStatusMessage("");
    }

    return 1;
}

int TKinokoBoard::ProcessSetCommand(istream& InputStream)
{
    string Name, Value;
    if (InputStream >> Name >> Value) {
	if (Name == "color") {
	    SetColor(Value);
	}
	else if (Name == "font") {
	    SetFont(Value);
	}
	else if (Name == "title") {
	    SetTitle(Value);
	}
	else {
	    return 0;
	}
    }
    else {
	return 0;
    }

    return 1;
}

int TKinokoBoard::ProcessClearCommand(istream& InputStream)
{
    _TextArea->Clear();
    return 1;
}

int TKinokoBoard::ProcessSaveCommand(istream& InputStream)
{
    string FileName;
    if (InputStream >> FileName) {
	SaveTo(FileName);
    }

    return 1;
}

int TKinokoBoard::ProcessQuitCommand(istream& InputStream)
{
    Quit();
    return 1;
}

void TKinokoBoard::SaveTo(const string& FileName)
{
}

void TKinokoBoard::SetColor(const string& ColorName)
{
    _TextArea->SetTextColorByName(ColorName);
}

void TKinokoBoard::SetFont(const string& FontName)
{
}

void TKinokoBoard::SetTitle(const string& Title)
{
}

void TKinokoBoard::WriteStatusMessage(const string& Message)
{
}

void TKinokoBoard::ScrollToTop(void)
{
    _TextArea->ScrollToTop();
}

void TKinokoBoard::ScrollToBottom(void)
{
    _TextArea->ScrollToBottom();
}

void TKinokoBoard::FreezeScrolling(void)
{
    _TextArea->FreezeScrolling();
    _IsScrollingFrozen = true;
}

void TKinokoBoard::ThawScrolling(void)
{
    _TextArea->ThawScrolling();
    _IsScrollingFrozen = false;
}

bool TKinokoBoard::IsScrollingFrozen(void)
{
    return _IsScrollingFrozen;
}
