/* KinokoCanvasImageArea.cc */
/* Created by Enomoto Sanshiro on 10 July 2000. */
/* Last updated by Enomoto Sanshiro on 12 April 2003. */


#include <sstream>
#include "KinokoCanvasImageArea.hh"

using namespace std;


TKinokoCanvasImageArea::TKinokoCanvasImageArea(int Width, int Height)
{
    _Width = Width;
    _Height = Height;
}

TKinokoCanvasImageArea::~TKinokoCanvasImageArea()
{
}

int TKinokoCanvasImageArea::Width(void)
{
    return _Width;
}

int TKinokoCanvasImageArea::Height(void)
{
    return _Height;
}

void TKinokoCanvasImageArea::DrawNumberText(float x, float y, float Number, const string& Adjustment)
{
    ostringstream NumberTextStream;
    NumberTextStream << Number;

    DrawText(x, y, NumberTextStream.str(), Adjustment);
}



TKinokoCanvasColor::TKinokoCanvasColor(void)
{
    _Red = 0;
    _Green = 0;
    _Blue = 0;
}

TKinokoCanvasColor::TKinokoCanvasColor(float Red, float Green, float Blue)
{
    _Red = Red;
    _Green = Green;
    _Blue = Blue;
}

TKinokoCanvasColor::~TKinokoCanvasColor()
{
}

float TKinokoCanvasColor::Red(void)
{
    return _Red;
}

float TKinokoCanvasColor::Green(void)
{
    return _Green;
}

float TKinokoCanvasColor::Blue(void)
{
    return _Blue;
}



TKinokoCanvasImage::TKinokoCanvasImage(int ImageId, int Width, int Height)
{
    _ImageId = ImageId;
    _Width = Width;
    _Height = Height;
}

TKinokoCanvasImage::~TKinokoCanvasImage()
{
}

int TKinokoCanvasImage::ImageId(void)
{
    return _ImageId;
}

int TKinokoCanvasImage::Width(void)
{
    return _Width;
}

int TKinokoCanvasImage::Height(void)
{
    return _Height;
}
