/* KinokoCanvasImageAreaEps.cc */
/* Created by Enomoto Sanshiro on 21 May 2002. */
/* Last updated by Enomoto Sanshiro on 10 June 2004. */


// ********************************************* //
// * THIS CODE IS VERY INCOMPLETE. DO NOT USE. * //
// ********************************************* //

// FIXME: does not work with UNICODE (KinokoCanvasTypeSetter)


#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
#include <map>
#include <cmath>
#include "MushMisc.hh"
#include "KinokoShellConfig.hh"
#include "KinokoCanvasImageArea.hh"
#include "KinokoCanvasImageAreaEps.hh"

using namespace std;



TKinokoCanvasImageAreaEps::TKinokoCanvasImageAreaEps(int Width, int Height, TKinokoCanvasImageArea* PrimaryImageArea)
: TKinokoCanvasImageArea(Width, Height)
{
    _PrimaryImageArea = PrimaryImageArea;

    _File = 0;
    _UnitSize = -1;
    _IsFontChanged = false;

    _CurrentColorIndex = 0;
    _CurrentLineWidth = 1;
    _CurrentLineStyleIndex = 0;
    _CurrentFontIndex = 0;
    _CurrentTextOrientation = 0;

    _PredefinedFontNameTable["times"] = "Times-Roman";
    _PredefinedFontNameTable["times-roman"] = "Times-Roman";
    _PredefinedFontNameTable["times-italic"] = "Times-Italic";
    _PredefinedFontNameTable["times-bold"] = "Times-Bold";
    _PredefinedFontNameTable["times-bolditalic"] = "Times-BoldItalic";
    _PredefinedFontNameTable["helvetica"] = "Helvetica";
    _PredefinedFontNameTable["helvetica-oblique"] = "Helvetica-Oblique";
    _PredefinedFontNameTable["helvetica-bold"] = "Helvetica-Bold";
    _PredefinedFontNameTable["helvetica-boldoblique"] = "Helvetica-BoldOblique";
    _PredefinedFontNameTable["courier"] = "Courier";
    _PredefinedFontNameTable["courier-oblique"] = "Courier-Oblique";
    _PredefinedFontNameTable["courier-bold"] = "Courier-Bold";
    _PredefinedFontNameTable["courier-boldoblique"] = "Courier-BoldOblique";
    _PredefinedFontNameTable["symbol"] = "Symbol";
}

TKinokoCanvasImageAreaEps::~TKinokoCanvasImageAreaEps()
{
    delete _File;
}

int TKinokoCanvasImageAreaEps::SetUnitSize(double PixelsPerInch)
{
    int Result = 0;

    if (PixelsPerInch > 0) {
	_UnitSize = PixelsPerInch;
	Result = 1;
    }

    return Result;
}

int TKinokoCanvasImageAreaEps::Open(const std::string& FileName)
{
    _File = new ofstream(FileName.c_str());
    if (! *_File) {
	delete _File;
	_File = 0;
	return 0;
    }
    _File->setf(ios::fixed);
    _File->precision(1);

    double Normalization = 1.0;
    if (_UnitSize > 0) {
	Normalization = 72.0 / _UnitSize;
    }

    float x0 = Normalization * DeviceXOf(0);
    float y0 = Normalization * DeviceYOf(_Height);
    float x1 = Normalization * DeviceXOf(_Width);
    float y1 = Normalization * DeviceYOf(0);

    *_File << "%!PS-Adobe-2.0 EPSF-2.0" << endl;
    *_File << "%%BoundingBox: ";
    *_File << x0 << " " << y0 << " " << x1 << " " << y1 << endl;
    *_File << "%%Title: (" << FileName << ")" << endl;
    *_File << "%%Creator: (KinokoCanvas)" << endl;
    *_File << "%%CreationDate: " ;
    *_File << "(" << TMushDateTime().AsString("%m/%d/%Y %H:%M") << ")" << endl;
    *_File << "%%EndComments" << endl;
    *_File << endl;

    *_File << "%%BeginProlog" << endl;
    *_File << "" << endl;
    *_File << "/kinokoellipsedict 16 dict def" << endl;
    *_File << "kinokoellipsedict /mtrx matrix put" << endl;
    *_File << "/kinokoellipse {" << endl;
    *_File << "  kinokoellipsedict begin" << endl;
    *_File << "  /yrad exch def /xrad exch def" << endl;
    *_File << "  /y exch def /x exch def" << endl;
    *_File << "  newpath" << endl;
    *_File << "  /savematrix mtrx currentmatrix def" << endl;
    *_File << "  x y translate" << endl;
    *_File << "  xrad yrad scale" << endl;
    *_File << "  0 0 1 0 360 arc" << endl;
    *_File << "  savematrix setmatrix" << endl;
    *_File << "  closepath" << endl;
    *_File << "  end" << endl;
    *_File << "} def" << endl;
    *_File << "" << endl;
    *_File << "/M { moveto } bind def" << endl;
    *_File << "/L { lineto } bind def" << endl;
    *_File << "/N { newpath } bind def" << endl;
    *_File << "/C { closepath } bind def" << endl;
    *_File << "/S { stroke } bind def" << endl;
    *_File << "/F { fill } bind def" << endl;
    *_File << "/RS { rectstroke } bind def" << endl;
    *_File << "/RF { rectfill } bind def" << endl;
    *_File << "/RGB { setrgbcolor } bind def" << endl;
    *_File << "" << endl;
    *_File << "%%EndProlog" << endl;
    *_File << endl;

    *_File << "false {" << endl;
    *_File << "  << /PageSize [842 595] /Policies << /PageSize 4 >> >> setpagedevice" << endl;
    *_File << "} if" << endl;
    *_File << endl;

    if (_UnitSize > 0) {
	*_File << Normalization << " " << Normalization << " scale" << endl;
	*_File << endl;
    }
    else {
	*_File << "true {" << endl;
	*_File << "  /margin 0 def" << endl;
	*_File << "  clippath pathbbox /y1 exch def /x1 exch def /y0 exch def /x0 exch def" << endl;
	*_File << "  /pw x1 x0 sub def /ph y1 y0 sub def" << endl;
	*_File << "  /iw " << _Width << " def /ih " << _Height << " def" << endl;
	*_File << "  /rx pw 2 margin mul sub iw div def" << endl;
	*_File << "  /ry ph 2 margin mul sub ih div def" << endl;
	*_File << "  rx ry le {" << endl;
	*_File << "    /r rx def" << endl;
	*_File << "    /x x0 margin add def" << endl;
	*_File << "  } {" << endl;
	*_File << "    /r ry def" << endl;
	*_File << "    /x x0 x1 add iw r mul sub 2 div def" << endl;
	*_File << "  } ifelse" << endl;
	*_File << "  x ph margin sub ih r mul sub translate" << endl;
	*_File << "  r r scale" << endl;
	*_File << "} if" << endl;
	*_File << endl;
    }

    string DefaultFontName = "Helvetica";
    int DefaultFontSize = 14;
    _FontNameTable[0] = make_pair(DefaultFontName, DefaultFontSize);
    _ColorTable[0] = TKinokoCanvasColor(0, 0, 0);

    *_File << "/" << DefaultFontName << " findfont" << " ";
    *_File << DefaultFontSize << " scalefont setfont" << endl;
    _IsFontChanged = false;

    return 1;
}

int TKinokoCanvasImageAreaEps::Close(void)
{
    if (_File) {
	*_File << "showpage" << endl;
	*_File << "%%EOF" << endl;

	delete _File;
	_File = 0;
    }

    return 1;
}


float TKinokoCanvasImageAreaEps::DeviceXOf(float x)
{
    return 1.0 * x;
}

float TKinokoCanvasImageAreaEps::DeviceYOf(float y)
{
    return (1.0 * (_Height - y));
}

void TKinokoCanvasImageAreaEps::Redraw(void)
{
    _PrimaryImageArea->Redraw();
}

void TKinokoCanvasImageAreaEps::Clear(void)
{
    //...
    _PrimaryImageArea->Clear();
}

void TKinokoCanvasImageAreaEps::ClearArea(float x0, float y0, float x1, float y1)
{
    //...
    _PrimaryImageArea->ClearArea(x0, y0, x1, y1);
}

int TKinokoCanvasImageAreaEps::SaveImageTo(const string& FileName)
{
    return _PrimaryImageArea->SaveImageTo(FileName);
}

void TKinokoCanvasImageAreaEps::DrawPoint(float x, float y)
{
    _PrimaryImageArea->DrawPoint(x, y);

    if (_File) {
	float r = 1.0;
	*_File << DeviceXOf(x) << " " << DeviceYOf(y);
	*_File << " " << r << " " << r << " ";
	*_File << "kinokoellipse" << " ";
	*_File << "F" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawLine(float x0, float y0, float x1, float y1)
{
    _PrimaryImageArea->DrawLine(x0, y0, x1, y1);

    if (_File) {
	*_File << "N" << " ";
	*_File << DeviceXOf(x0) << " " << DeviceYOf(y0) << " M" << " ";
	*_File << DeviceXOf(x1) << " " << DeviceYOf(y1) << " L" << " ";
	*_File << "S" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawRect(float x0, float y0, float x1, float y1)
{
    _PrimaryImageArea->DrawRect(x0, y0, x1, y1);

    if (_File) {
	float Width = DeviceXOf(x1) - DeviceXOf(x0);
	float Height = DeviceYOf(y1) - DeviceYOf(y0);
	*_File << DeviceXOf(x0) << " " << DeviceYOf(y0) << " ";
	*_File << Width << " " << Height << " RS" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawRectFill(float x0, float y0, float x1, float y1)
{
    _PrimaryImageArea->DrawRectFill(x0, y0, x1, y1);

    if (_File) {
	float Width = DeviceXOf(x1) - DeviceXOf(x0);
	float Height = DeviceYOf(y1) - DeviceYOf(y0);
	*_File << DeviceXOf(x0) << " " << DeviceYOf(y0) << " ";
	*_File << Width << " " << Height << " RF" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawLines(const vector<pair<float, float> >& PointList)
{
    _PrimaryImageArea->DrawLines(PointList);

    if (_File) {
	*_File << "N" << " ";
	if (PointList.size() > 0) {
	    *_File << DeviceXOf(PointList[0].first) << " ";
	    *_File << DeviceYOf(PointList[0].second) << " ";
	    *_File << "M" << " ";
	}
	for (unsigned i = 1; i < PointList.size(); i++) {
	    *_File << DeviceXOf(PointList[i].first) << " ";
	    *_File << DeviceYOf(PointList[i].second) << " ";
	    *_File << "L" << " ";
	}
	*_File << "S" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawPolygon(const vector<pair<float, float> >& PointList)
{
    _PrimaryImageArea->DrawPolygon(PointList);

    if (_File) {
	*_File << "N" << " ";
	if (PointList.size() > 0) {
	    *_File << DeviceXOf(PointList[0].first) << " ";
	    *_File << DeviceYOf(PointList[0].second) << " ";
	    *_File << "M" << " ";
	}
	for (unsigned i = 1; i < PointList.size(); i++) {
	    *_File << DeviceXOf(PointList[i].first) << " ";
	    *_File << DeviceYOf(PointList[i].second) << " ";
	    *_File << "L" << " ";
	}
	*_File << "C S" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawPolygonFill(const vector<pair<float, float> >& PointList)
{
    _PrimaryImageArea->DrawPolygonFill(PointList);

    if (_File) {
	*_File << "N" << " ";
	if (PointList.size() > 0) {
	    *_File << DeviceXOf(PointList[0].first) << " ";
	    *_File << DeviceYOf(PointList[0].second) << " ";
	    *_File << "M" << " ";
	}
	for (unsigned i = 1; i < PointList.size(); i++) {
	    *_File << DeviceXOf(PointList[i].first) << " ";
	    *_File << DeviceYOf(PointList[i].second) << " ";
	    *_File << "L" << " ";
	}
	*_File << "C F" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawCircle(float x, float y, float r)
{
    _PrimaryImageArea->DrawCircle(x, y, r);

    if (_File) {
	float RadiusX = fabs(DeviceXOf(x + r) - DeviceXOf(x));
	float RadiusY = fabs(DeviceYOf(y + r) - DeviceYOf(y));
	*_File << DeviceXOf(x) << " " << DeviceYOf(y) << " ";
	*_File << RadiusX << " " << RadiusY << " ";
	*_File << "kinokoellipse S" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawCircleFill(float x, float y, float r)
{
    _PrimaryImageArea->DrawCircleFill(x, y, r);

    if (_File) {
	float RadiusX = fabs(DeviceXOf(x + r) - DeviceXOf(x));
	float RadiusY = fabs(DeviceYOf(y + r) - DeviceYOf(y));
	*_File << DeviceXOf(x) << " " << DeviceYOf(y) << " ";
	*_File << RadiusX << " " << RadiusY << " ";
	*_File << "kinokoellipse F" << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawEllipse(float x, float y, float rx, float ry, float Angle)
{
    _PrimaryImageArea->DrawEllipse(x, y, rx, ry);

    if (_File) {
	float RadiusX = fabs(DeviceXOf(x + rx) - DeviceXOf(x));
	float RadiusY = fabs(DeviceYOf(y + ry) - DeviceYOf(y));
	*_File << "gsave" << endl;
	*_File << DeviceXOf(x) << " " << DeviceYOf(y) << " ";
	*_File << RadiusX << " " << RadiusY << " ";
	*_File << "kinokoellipse S" << endl;
	*_File << "grestore";
	*_File << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawEllipseFill(float x, float y, float rx, float ry, float Angle)
{
    _PrimaryImageArea->DrawEllipseFill(x, y, rx, ry);

    if (_File) {
	float RadiusX = fabs(DeviceXOf(x + rx) - DeviceXOf(x));
	float RadiusY = fabs(DeviceYOf(y + ry) - DeviceYOf(y));
	*_File << "gsave" << endl;
	*_File << DeviceXOf(x) << " " << DeviceYOf(y) << " ";
	*_File << RadiusX << " " << RadiusY << " ";
	*_File << "kinokoellipse F" << endl;
	*_File << "grestore";
	*_File << endl;
    }
}

void TKinokoCanvasImageAreaEps::DrawText(float x, float y, const string& Text, const string& Adjustment)
{
    _PrimaryImageArea->DrawText(x, y, Text, Adjustment);

    if (! _File || Text.empty()) {
	return;
    }

    if (_IsFontChanged) {
	string FontName = _FontNameTable[_CurrentFontIndex].first;
	int FontSize = _FontNameTable[_CurrentFontIndex].second;
	if (FontSize > 0) {
	    *_File << "/" << FontName << " findfont" << " ";
	    *_File << FontSize << " scalefont setfont" << endl;
	}
	_IsFontChanged = false;
    }

    if (! Adjustment.empty()) {
	SetTextAdjustment(Adjustment);
    }

    *_File << "gsave" << endl;

    string EscapedText;
    for (unsigned i = 0; i < Text.size(); i++) {
	char Char = Text[i];
	if ((Char == '(') || (Char == ')')) {
	    EscapedText += '\\';
	}
	EscapedText += Char;
    }

    *_File << "(" << EscapedText << ") dup" << endl;

    *_File << "N" << " ";
    *_File << "0 0 M" << " ";
    *_File << /*Text*/ "false charpath" << " ";
    *_File << "pathbbox" << endl;
    *_File << "/h exch def /w exch def pop pop" << endl;

    *_File << "/x " << DeviceXOf(x) << " def" << " ";
    *_File << "/y " << DeviceYOf(y) << " def" << " ";
    *_File << "/d " << _CurrentTextOrientation << " def" << endl;

    if (_CurrentTextOrientation != 0) {
	*_File << "/w1 d cos abs w mul d sin abs h mul add def" << endl;
	*_File << "/h1 d sin abs w mul d cos abs h mul add def" << endl;
    }
    else {
	*_File << "/w1 w def" << endl;
	*_File << "/h1 h def" << endl;
    }

    if (_HorizontalTextAdjustment == TextAdjustment_Right) {
	*_File << "x w1 2 div sub" << " ";
    }
    else if (_HorizontalTextAdjustment == TextAdjustment_Left) {
	*_File << "x w1 2 div add" << " ";
    }
    else {
	*_File << "x" << " ";
    }
    if (_VerticalTextAdjustment == TextAdjustment_Top) {
	*_File << "y h1 2 div sub" << " ";
    }
    else if (_VerticalTextAdjustment == TextAdjustment_Bottom) {
	*_File << "y h1 2 div add" << " ";
    }
    else {
	*_File << "y" << " ";
    }
    *_File << "translate d rotate" << endl;

    *_File << "w -2 div h -2 div M" << " ";
    *_File << /*Text*/ "show" << endl;

    *_File << "grestore" << endl;
}

int TKinokoCanvasImageAreaEps::AllocateColor(const std::string& ColorName)
{
    int ColorIndex = _PrimaryImageArea->AllocateColor(ColorName);

    if (_ColorTable.count(ColorIndex) == 0) {
	_PrimaryImageArea->GetColor(ColorIndex, _ColorTable[ColorIndex]);
    }

    return ColorIndex;
}

int TKinokoCanvasImageAreaEps::AllocateColorRgb(float Red, float Green, float Blue)
{
    int ColorIndex = _PrimaryImageArea->AllocateColorRgb(Red, Green, Blue);
    _ColorTable[ColorIndex] = TKinokoCanvasColor(Red, Green, Blue);

    return ColorIndex;
}

int TKinokoCanvasImageAreaEps::SetColor(int ColorIndex)
{
    if ((ColorIndex < 0) || (ColorIndex == _CurrentColorIndex)) {
	return _CurrentColorIndex;
    }

    int OldColorIndex = _PrimaryImageArea->SetColor(ColorIndex);
    _CurrentColorIndex = ColorIndex;

    if (_File) {
	int PreviousPrecision = _File->precision(2);
	*_File << _ColorTable[ColorIndex].Red() << " ";
	*_File << _ColorTable[ColorIndex].Green() << " ";
	*_File << _ColorTable[ColorIndex].Blue() << " ";
	*_File << "RGB" << endl;
	_File->precision(PreviousPrecision);
    }

    return OldColorIndex;
}

int TKinokoCanvasImageAreaEps::SetBackgroundColor(int ColorIndex)
{
    //...
    return _PrimaryImageArea->SetBackgroundColor(ColorIndex);
}

bool TKinokoCanvasImageAreaEps::GetColor(int ColorIndex, TKinokoCanvasColor& Color)
{
    return _PrimaryImageArea->GetColor(ColorIndex, Color);
}

int TKinokoCanvasImageAreaEps::SetLineWidth(int LineWidth)
{
    if (LineWidth == _CurrentLineWidth) {
	return _CurrentLineWidth;
    }

    int OldLineWidth = _PrimaryImageArea->SetLineWidth(LineWidth);
    _CurrentLineWidth = LineWidth;

    if (_File) {
	*_File << LineWidth << " setlinewidth" << endl;
    }

    return OldLineWidth;
}

int TKinokoCanvasImageAreaEps::CreateLineStyle(const string& LineStyleName)
{
    int LineStyleIndex =  _PrimaryImageArea->CreateLineStyle(LineStyleName);

    if (LineStyleIndex <= 0) {
	return LineStyleIndex;
    }

    if (_LineStyleTable.count(LineStyleIndex) == 0) {
	vector<int> LineStyle;
	_PrimaryImageArea->GetLineStyle(LineStyleIndex, LineStyle);

	ostringstream LineStyleStream;
	LineStyleStream << "[ ";
	for (unsigned i = 0; i < LineStyle.size(); i++) {
	    LineStyleStream << LineStyle[i] << " ";
	}
	LineStyleStream << "] ";

	_LineStyleTable[LineStyleIndex] = LineStyleStream.str();
    }

    return LineStyleIndex;
}

int TKinokoCanvasImageAreaEps::SetLineStyle(int LineStyleIndex, unsigned Offset)
{
    if (LineStyleIndex == _CurrentLineStyleIndex) {
	return _CurrentLineStyleIndex;
    }

    int OldLineStyleIndex = _PrimaryImageArea->SetLineStyle(LineStyleIndex, Offset);
    _CurrentLineStyleIndex = LineStyleIndex;

    if (_File) {
	if (LineStyleIndex <= 0) {
	    *_File << "[] 0 setdash" << endl;
	}
	else if (_LineStyleTable.count(LineStyleIndex)) {
	    *_File << _LineStyleTable[LineStyleIndex] << " ";
	    *_File << Offset << " setdash" << endl;
	}
    }

    return OldLineStyleIndex;
}

bool TKinokoCanvasImageAreaEps::GetLineStyle(int LineStyleIndex, vector<int>& LineStyle)
{
    return _PrimaryImageArea->GetLineStyle(LineStyleIndex, LineStyle);
}

int TKinokoCanvasImageAreaEps::SetDrawingFunction(int FunctionId)
{
    return _PrimaryImageArea->SetDrawingFunction(FunctionId);
}

int TKinokoCanvasImageAreaEps::LoadFont(const string& FontName, int FontSize)
{
    int FontIndex = _PrimaryImageArea->LoadFont(FontName, FontSize);

    if (FontIndex < 0) {
	return FontIndex;
    }

    if (_FontNameTable.count(FontIndex) > 0) {
	return FontIndex;
    }

    string SystemFontName;
    if (_PredefinedFontNameTable.count(FontName) > 0) {
	SystemFontName = _PredefinedFontNameTable[FontName];
    }
    else {
	SystemFontName = "Times-Roman";
    }
    if (! SystemFontName.empty()) {
	_FontNameTable[FontIndex] = make_pair(SystemFontName, FontSize);
    }

    return FontIndex;
}

int TKinokoCanvasImageAreaEps::LoadSymbolFont(int FontSize)
{
    int FontIndex = _PrimaryImageArea->LoadSymbolFont(FontSize);

    if (FontIndex < 0) {
	return FontIndex;
    }

    if (_FontNameTable.count(FontIndex) > 0) {
	return FontIndex;
    }

#if USE_PANGO
    //... TODO: specify UNICODE font ...//
    _FontNameTable[FontIndex] = make_pair("Times-Roman", FontSize);
#else
    _FontNameTable[FontIndex] = make_pair("Symbol", FontSize);
#endif

    return FontIndex;
}

int TKinokoCanvasImageAreaEps::SetFont(int FontIndex)
{
    if (FontIndex < 0) {
	return _CurrentFontIndex;
    }

    if (FontIndex == _CurrentFontIndex) {
	return _CurrentFontIndex;
    }

    int OldFontIndex = _PrimaryImageArea->SetFont(FontIndex);
    _CurrentFontIndex = FontIndex;

    _IsFontChanged = true;

    return OldFontIndex;
}

string TKinokoCanvasImageAreaEps::SetTextAdjustment(const string& Adjustment)
{
    string OldAdjustment = _PrimaryImageArea->SetTextAdjustment(Adjustment);

    _HorizontalTextAdjustment = TextAdjustment_Center;
    _VerticalTextAdjustment = TextAdjustment_Center;

    if (Adjustment.find_first_of('t') != string::npos) {
	_VerticalTextAdjustment = TextAdjustment_Top;
    }
    if (Adjustment.find_first_of('b') != string::npos) {
	_VerticalTextAdjustment = TextAdjustment_Bottom;
    }
    if (Adjustment.find_first_of('l') != string::npos) {
	_HorizontalTextAdjustment = TextAdjustment_Left;
    }
    if (Adjustment.find_first_of('r') != string::npos) {
	_HorizontalTextAdjustment = TextAdjustment_Right;
    }

    return OldAdjustment;
}

int TKinokoCanvasImageAreaEps::SetTextOrientation(int Degree)
{
    int OldTextOrientation = _PrimaryImageArea->SetTextOrientation(Degree);
    _CurrentTextOrientation = Degree;

    return OldTextOrientation;
}

int TKinokoCanvasImageAreaEps::TextHeightOf(const string& Text)
{
    return _PrimaryImageArea->TextHeightOf(Text);
}

int TKinokoCanvasImageAreaEps::TextAscentOf(const string& Text)
{
    return _PrimaryImageArea->TextAscentOf(Text);
}

int TKinokoCanvasImageAreaEps::TextWidthOf(const string& Text)
{
    return _PrimaryImageArea->TextWidthOf(Text);
}

TKinokoCanvasImage* TKinokoCanvasImageAreaEps::LoadImage(const string& FileName)
{
    return _PrimaryImageArea->LoadImage(FileName);
}

void TKinokoCanvasImageAreaEps::DrawImage(float x, float y, TKinokoCanvasImage* Image)
{
    //... TODO: implement this ...//
    _PrimaryImageArea->DrawImage(x, y, Image);
}
