/* KinokoCanvasMarker.hh */
/* Created by Enomoto Sanshiro on 18 May 2002. */
/* Last updated by Enomoto Sanshiro on 18 May 2002. */


#ifndef __KinokoCanvasMarker_hh
#define __KinokoCanvasMarker_hh


#include <string>
#include <map>
#include "KinokoCanvasImageArea.hh"


class TKinokoCanvasMarker {
  public:
    TKinokoCanvasMarker(void);
    virtual ~TKinokoCanvasMarker();
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "") = 0;
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size) = 0;
};


class TKinokoCanvasMarkerFactory {
  public:
    TKinokoCanvasMarkerFactory(void);
    virtual ~TKinokoCanvasMarkerFactory();
    virtual void Construct(void);
    virtual void AddMarker(const std::string& Name, TKinokoCanvasMarker* Marker);
    virtual TKinokoCanvasMarker* CreateMarker(const std::string& Name, const std::string& Parameter = "");
  protected:
    bool _IsConstructed;
    std::map<std::string, TKinokoCanvasMarker*> _MarkerPrototypeTable;
};


class TKinokoCanvasCircleMarker: public TKinokoCanvasMarker {
  public:
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
};


class TKinokoCanvasSquareMarker: public TKinokoCanvasMarker {
  public:
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
};


class TKinokoCanvasTriangleMarker: public TKinokoCanvasMarker {
  public:
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
};


class TKinokoCanvasDiamondMarker: public TKinokoCanvasMarker {
  public:
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
};


class TKinokoCanvasOpenCircleMarker: public TKinokoCanvasMarker {
  public:
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
};


class TKinokoCanvasOpenSquareMarker: public TKinokoCanvasMarker {
  public:
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
};


class TKinokoCanvasOpenTriangleMarker: public TKinokoCanvasMarker {
  public:
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
};


class TKinokoCanvasOpenDiamondMarker: public TKinokoCanvasMarker {
  public:
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
};


class TKinokoCanvasImageMarker: public TKinokoCanvasMarker {
  public:
    TKinokoCanvasImageMarker(const std::string& ImageFileName = "");
    virtual ~TKinokoCanvasImageMarker();
    virtual TKinokoCanvasMarker* Clone(const std::string& Parameter = "");
    virtual void Draw(TKinokoCanvasImageArea* ImageArea, float X, float Y, float Size);
  protected:
    std::string _ImageFileName;
    TKinokoCanvasImage* _Image;
    float _HalfWidth, _HalfHeight;
};


#endif
