/* KinokoCanvasObject.hh */
/* Created by Enomoto Sanshiro on 10 July 2000. */
/* Last updated by Enomoto Sanshiro on 19 August 2008. */


#ifndef __KinokoCanvasObject_hh
#define __KinokoCanvasObject_hh


#include <iostream>
#include <string>
#include <map>
#include "KinokoCanvasImageArea.hh"
#include "KinokoCanvasTypesetter.hh"
#include "KinokoShell.hh"


class TKinokoCanvas;


class TKinokoCanvasObject: public TKinokoShellObject {
  public:
    TKinokoCanvasObject(TKinokoCanvas* Canvas);
    virtual ~TKinokoCanvasObject();
    virtual void Initialize(void);
    virtual int Construct(std::istream& InputStream);
    virtual void SetPosition(int OffsetX, int OffsetY, int Width, int Height);
    virtual bool Includes(int X, int Y);
    virtual std::vector<std::string> ActionList(void);
    virtual int ProcessAction(const std::string& ActionName);
    virtual int ProcessRangeSelect(int X0, int Y0, int X1, int Y1);
    virtual void Clear(void);
  protected:
    TKinokoCanvas* _Canvas;
    TKinokoCanvasImageArea* _ImageArea;
    TKinokoCanvasTypesetter* _Typesetter;
    int _OffsetX, _OffsetY, _Width, _Height;    
    int _LabelCharacterHeight, _LabelCharacterWidth;
    int _NormalFontLineHeight;
  protected:
    enum TColorEnum {
	Color_Foreground,
	Color_Background,
	Color_Black,
	Color_White,
	_NumberOfEnumColors
    };
    std::string _ColorList[_NumberOfEnumColors];
    int _ColorIndexList[_NumberOfEnumColors];
  protected:
    enum TLineStyleEnum {
	LineStyle_Solid,
	LineStyle_Dot,
	LineStyle_Dash,
	_NumberOfEnumLineStyles
    };
    int _LineStyleIndexList[_NumberOfEnumLineStyles];
  protected:
    enum TFontEnum {
	Font_Normal,
	Font_Title,
	Font_Label,
	_NumberOfEnumFonts
    };
    std::pair<std::string, int> _FontList[_NumberOfEnumFonts];
    int _FontIndexList[_NumberOfEnumFonts];
    TKinokoCanvasMathTextComposer* _MathTextComposerList[_NumberOfEnumFonts];
};


#endif
