/* KinokoCanvasPictureObject.cc */
/* Created by Enomoto Sanshiro on 11 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 January 2002. */


#include <algorithm>
#include <cmath>
#include "KinokoCanvasFramedObject.hh"
#include "KinokoCanvasPictureObject.hh"

using namespace std;


TKinokoCanvasPictureObject::TKinokoCanvasPictureObject(TKinokoCanvas* Canvas)
: TKinokoCanvasFramedObject(Canvas)
{
}

TKinokoCanvasPictureObject::~TKinokoCanvasPictureObject()
{
}

TKinokoShellObject* TKinokoCanvasPictureObject::Clone(void)
{
    return new TKinokoCanvasPictureObject(_Canvas);
}

void TKinokoCanvasPictureObject::Initialize(void) 
{
    TKinokoCanvasFramedObject::Initialize();
}

float TKinokoCanvasPictureObject::CanvasXOf(float x)
{
    return (x - _XMin) / _XWidth * _Width + _OffsetX;
}

float TKinokoCanvasPictureObject::CanvasYOf(float y)
{
    return (y - _YMin) / _YWidth * _Height + _OffsetY;
}
