/* KinokoCanvasTextArea.cc */
/* Created by Enomoto Sanshiro on 10 July 2000. */
/* Last updated by Enomoto Sanshiro on 10 July 2000. */


#include "KinokoCanvasTextArea.hh"

using namespace std;


TKinokoCanvasTextArea::TKinokoCanvasTextArea(void)
{
}

TKinokoCanvasTextArea::~TKinokoCanvasTextArea()
{
}

int TKinokoCanvasTextArea::SetTextColorByName(const string& ColorName)
{
    if (_PredefinedColorIndexTable.empty()) {
	AllocatePredefinedColors();
    }

    int OldColorIndex = _CurrentColorIndex;
    if (_PredefinedColorIndexTable.count(ColorName) > 0) {
	int ColorIndex = _PredefinedColorIndexTable[ColorName];
	SetTextColor(ColorIndex);
    }

    return OldColorIndex;
}

int TKinokoCanvasTextArea::SetFontByName(const string& FontName)
{
    if (_PredefinedFontIndexTable.empty()) {
	LoadPredefinedFonts();
    }

    int OldFontIndex = _CurrentFontIndex;
    if (_PredefinedFontIndexTable.count(FontName) > 0) {
	int FontIndex = _PredefinedFontIndexTable[FontName];
	SetFont(FontIndex);
    }

    return OldFontIndex;
}

void TKinokoCanvasTextArea::AllocatePredefinedColors(void)
{
    _PredefinedColorIndexTable["white"] = AllocateColor(1.0, 1.0, 1.0);
    _PredefinedColorIndexTable["black"] = AllocateColor(0, 0, 0);
    _PredefinedColorIndexTable["gray"] = AllocateColor(0.5, 0.5, 0.5);
    _PredefinedColorIndexTable["red"] = AllocateColor(1.0, 0, 0);
    _PredefinedColorIndexTable["green"] = AllocateColor(0, 0.6, 0);
    _PredefinedColorIndexTable["blue"] = AllocateColor(0, 0, 1.0);
    _PredefinedColorIndexTable["yellow"] = AllocateColor(0.9, 0.8, 0);
    _PredefinedColorIndexTable["cyan"] = AllocateColor(0, 0.8, 0.8);
    _PredefinedColorIndexTable["magenta"] = AllocateColor(0.55, 0, 0.55);
    _PredefinedColorIndexTable["orange"] = AllocateColor(1.0, 0.65, 0);
    _PredefinedColorIndexTable["brown"] = AllocateColor(0.54, 0.27, 0.07);
    _PredefinedColorIndexTable["bluegreen"] = AllocateColor(0.13, 0.70, 0.67);
    _PredefinedColorIndexTable["greenyellow"] = AllocateColor(0.68, 1.0, 0.18);
    _PredefinedColorIndexTable["wheat"] = AllocateColor(0.8, 0.67, 0.49);
    _PredefinedColorIndexTable["lightred"] = AllocateColor(1.0, 0.5, 0.5);
    _PredefinedColorIndexTable["lightgreen"] = AllocateColor(0.5, 1.0, 0.5);
    _PredefinedColorIndexTable["lightblue"] = AllocateColor(0.5, 0.5, 1.0);
    _PredefinedColorIndexTable["lightyellow"] = AllocateColor(1.0, 1.0, 0.3);
    _PredefinedColorIndexTable["lightcyan"] = AllocateColor(0.5, 1.0, 1.0);
    _PredefinedColorIndexTable["lightmagenta"] = AllocateColor(1.0, 0.5, 1.0);
    _PredefinedColorIndexTable["lightgray"] = AllocateColor(0.83, 0.83, 0.83);
}

void TKinokoCanvasTextArea::LoadPredefinedFonts(void)
{
}
