/* KinokoControlPanelScript.hh */
/* Created by Enomoto Sanshiro on 28 September 2001. */
/* Last updated by Enomoto Sanshiro on 1 August 2003. */


#ifndef __KinokoControlPanelScript_hh
#define __KinokoControlPanelScript_hh


#include <string>
#include <map>
#include <deque>
#include "MushXml.hh"
#include "KinokoControlPanel.hh"


class TKinokoControlPanelScript {
  public:
    TKinokoControlPanelScript(TKinokoControlPanel* ControlPanel, const std::string& ScriptFileName);
    virtual ~TKinokoControlPanelScript();
    virtual void Go(void) = 0;
  public:
    virtual void OnStartWidget(const std::string& WidgetTypeName, std::map<std::string, std::string>& OptionTable);
    virtual void OnEndWidget(const std::string& WidgetTypeName);
    virtual void OnText(const std::string& Text);
    virtual void OnCommentText(const std::string& Text);
    virtual void OnScriptError(const std::string& Message, int LineNumber = 0);
    virtual long LineNumber(void) = 0;
  protected:
    TKinokoControlPanel* _ControlPanel;
    std::string _ScriptFileName;
    std::string _CurrentText;
    std::deque<std::string> _TextStack;
    std::string _CurrentVisualWidgetName;
    TKinokoControlVisualWidget* _CurrentVisualWidget;
    bool _ReadsCommentCharacter;
    long _CurrentTextStartLineNumber;
};


class TKinokoXmlControlPanelScript: public TKinokoControlPanelScript, public mush::sax::DocumentHandler {
  public:
    TKinokoXmlControlPanelScript(TKinokoControlPanel* ControlPanel, const std::string& ScriptFileName);
    virtual ~TKinokoXmlControlPanelScript();
    virtual void Go(void);
    virtual long LineNumber(void);
  public:
    virtual void startElement(const std::string& name, const TMushSaxAttributeList& attribute_list);
    virtual void endElement(const std::string& name);
    virtual void characters(const std::string& text);
    virtual void comment(const std::string& comment);
    virtual void warning(const std::string& message);
    virtual void error(const std::string& message);
    virtual void fatalError(const std::string& message);
    virtual void setDocumentLocator(mush::sax::Locator* locator);
  protected:
    mush::sax::Parser* _Parser;
    mush::sax::Locator* _Locator;
};


#endif
