/* KinokoControlViewlet.hh */
/* Created by Enomoto Sanshiro on 9 August 2007. */
/* Last updated by Enomoto Sanshiro on 9 August 2007. */


#ifndef __KinokoControlViewlet_hh
#define __KinokoControlViewlet_hh


#include <iostream>
#include <string>
#include "KumaVector.hh"
#include "KinokoCanvas.hh"
#include "KinokoControlWidget.hh"


class TKinokoControlViewletCanvas: public TKinokoCanvas {
  public:
    TKinokoControlViewletCanvas(TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlViewletCanvas();
    virtual void Start(void);
    virtual void Quit(void);
  protected:
    virtual TKinokoShellPopupWindow* CreatePopupWindow(void);
    virtual TKinokoShellFileSelectDialog* CreateFileSelectDialog(void);
    virtual int OpenContextMenu(TKinokoCanvasObject* CanvasObject);
  protected:
    TKinokoControlImagePort* _ImagePort;
};


class TKinokoControlViewlet: public TKinokoControlWidget {
  public:
    TKinokoControlViewlet(const std::string& Name, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlViewlet();
    virtual void Enable(void);
    virtual void Disable(void);
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual void Initialize(void);
    virtual void Redraw(void);
    virtual void SetColor(const std::string& ColorName);
    virtual void SetForegroundColor(const std::string& ColorName);
    virtual void SetBackgroundColor(const std::string& ColorName);
  protected:
    TKinokoControlImagePort* _ImagePort;
    TKinokoControlViewletCanvas* _Canvas;
    std::string _Color, _ForegroundColor, _BackgroundColor;
};


class TKinokoControlCanvasViewlet: public TKinokoControlViewlet {
  public:
    TKinokoControlCanvasViewlet(const std::string& Name, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlCanvasViewlet();
    virtual void Initialize(void);
    virtual void SetValue(const std::string& Value);
  public:
    virtual void Clear(void);
    virtual void DrawLine(float x0, float y0, float x1, float y1);
    virtual void DrawCircle(float x, float y, float radius);
    virtual void DrawText(float x, float y, const std::string& Text);
};


class TKinokoControlPlotViewlet: public TKinokoControlViewlet {
  public:
    TKinokoControlPlotViewlet(const std::string& Name, TKinokoControlImagePort* ImagePort);
    TKinokoControlPlotViewlet(const std::string& Name, TKinokoControlImagePort* ImagePort, float XMin, float XMax, float YMin, float YMax);
    virtual ~TKinokoControlPlotViewlet();
    virtual void Initialize(void);
    virtual void SetValue(const std::string& Value);
  public:
    virtual void Clear(void);
    virtual void SetLineWidth(int LineWidth);
    virtual void SetMarker(const std::string& MarkerName, int MarkerSize);
    virtual void SetRange(float XMin, float XMax, float YMin, float YMax);
    virtual void SetYScaleLog(void);
    virtual void SetTimeTick(long Epoch, const std::string& Format, std::string Unit, int Step); 
    virtual void ResetRange(void);
    virtual void GuessRange(kuma::TKumaVector& XList, kuma::TKumaVector& YList);
    virtual void Draw(kuma::TKumaVector& XList, kuma::TKumaVector& YList);
  protected:
    float _XMin, _XMax, _YMin, _YMax;
    bool _IsLineUsed, _IsMarkerUsed;
    bool _IsRangeDecided, _IsYScaleLog;
};


#endif
