/* KinokoControlVisualWidge.hh */
/* Created by Enomoto Sanshiro on 24 April 2006. */
/* Last updated by Enomoto Sanshiro 6 April 2007. */


#ifndef __KinokoControlVisualWidget_hh
#define __KinokoControlVisualWidget_hh


#include <string>
#include <vector>
#include <map>
#include "KinokoControlWidget.hh"
#include "KinokoCanvasImageArea.hh"


class TKinokoControlVisualWidgetCreator {
  public:
    TKinokoControlVisualWidgetCreator(void) {}
    virtual ~TKinokoControlVisualWidgetCreator() {}
    virtual TKinokoControlVisualWidget* CreateInstance(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort) = 0;
};


class TKinokoControlVisualWidgetTable {
  protected:
    TKinokoControlVisualWidgetTable(void);
    virtual ~TKinokoControlVisualWidgetTable();
  public:
    static TKinokoControlVisualWidgetTable* GetInstance(void);
    static void DestroyInstance(void);
  public:
    virtual void AddWidgetCreator(const std::string& WidgetTypeName, TKinokoControlVisualWidgetCreator* Creator);
    virtual TKinokoControlVisualWidgetCreator* FindWidgetCreator(const std::string& WidgetTypeName);
    virtual void ConstructTable(void);
    virtual void DestroyTable(void);
  protected:
    static TKinokoControlVisualWidgetTable* _Instance;
    std::map<std::string, TKinokoControlVisualWidgetCreator*> _CreatorTable;
};



class TKinokoControlVisualDisplayWidget: public TKinokoControlVisualWidget {
  public:
    TKinokoControlVisualDisplayWidget(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlVisualDisplayWidget();
    virtual int DefaultWidth(void);
    virtual int DefaultHeight(void);
    virtual void Initialize(void);
    virtual void SetValue(const std::string& Value);
    virtual bool SetAttribute(const std::string& Name, const std::string& Value);
    virtual bool GetAttribute(const std::string& Name, std::string& Value);
  protected:
    std::string _Foreground, _Background;
    std::string _Alignment;
    std::string _Label;
};


class TKinokoControlVisualLightButtonWidget: public TKinokoControlVisualWidget {
  public:
    TKinokoControlVisualLightButtonWidget(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlVisualLightButtonWidget();
    virtual int DefaultWidth(void);
    virtual int DefaultHeight(void);
    virtual void Initialize(void);
    virtual void SetValue(const std::string& Value);
    virtual void OnButtonPress(int ButtonNumber);
    virtual void OnButtonRelease(int ButtonNumber);
  protected:
    void DrawPressed(void);
    void DrawReleased(void);
  protected:
    float _Radius;
    std::string _Label;
  private:
    bool _IsBeingPressed;
    int _CurrentColorIndex, _TextColorIndex;
};


class TKinokoControlVisualIndicatorWidget: public TKinokoControlVisualWidget {
  public:
    TKinokoControlVisualIndicatorWidget(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlVisualIndicatorWidget();
    virtual int DefaultWidth(void);
    virtual int DefaultHeight(void);
    virtual void Initialize(void);
    virtual void SetValue(const std::string& Value);
    virtual void OnButtonPress(int ButtonNumber);
    virtual void OnButtonRelease(int ButtonNumber);
  protected:
    void DrawPressed(void);
    void DrawReleased(void);
  protected:
    std::string _Label;
  private:
    bool _IsBeingPressed;
    int _CurrentColorIndex, _TextColorIndex;
};


class TKinokoControlVisualMeterWidget: public TKinokoControlVisualWidget {
  public:
    TKinokoControlVisualMeterWidget(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlVisualMeterWidget();
    virtual int DefaultWidth(void);
    virtual int DefaultHeight(void);
    virtual bool AddDecoration(const std::string& Name, std::map<std::string, std::string>& OptionTable);
    virtual void Initialize(void);
    virtual void SetValue(const std::string& Value);
  protected:
    std::string _Label;
    float _Angle, _Min, _Max, _ScaleMark, _Radius;
    float _X0, _Y0;
    std::vector<std::pair<std::pair<std::string, int>, std::pair<float, float> > > _RangeList;
  private:
    int _ColorIndex;
    int _LabelFontId, _ScaleFontId;
};


class TKinokoControlVisualGuageWidget: public TKinokoControlVisualWidget {
  public:
    TKinokoControlVisualGuageWidget(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlVisualGuageWidget();
    virtual int DefaultWidth(void);
    virtual int DefaultHeight(void);
    virtual bool AddDecoration(const std::string& Name, std::map<std::string, std::string>& OptionTable);
    virtual void Initialize(void);
    virtual void SetValue(const std::string& Value);
  protected:
    std::string _Foreground, _Background;
    std::string _Label;
    int _LabelFontId, _ScaleFontId;
    float _Min, _Max, _ScaleMark;
    float _Length, _Wideness, _Margin;
    bool _IsScaleDisabled;
    std::vector<std::pair<std::pair<std::string, int>, std::pair<float, float> > > _RangeList;
  private:
    int _ForegroundIndex, _BackgroundIndex;
};


class TKinokoControlVisualSliderWidget: public TKinokoControlVisualWidget {
  public:
    TKinokoControlVisualSliderWidget(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlVisualSliderWidget();
    virtual int DefaultWidth(void);
    virtual int DefaultHeight(void);
    virtual void Initialize(void);
    virtual void SetValue(const std::string& Value);
    virtual void OnButtonPress(int ButtonNumber);
  protected:
    std::string _Foreground;
    std::string _Label;
    std::string _Selection;
    std::vector<std::string> _SelectionList;
    std::map<std::string, int> _SelectionTable;
    int _LabelFontId, _ScaleFontId;
    float _Min, _Max, _ScaleMark, _Step;
    float _Length, _Wideness, _Margin;
    bool _IsScaleDisabled;
    float _CurrentValue;
    int _CurrentSelectionIndex;
  private:
    int _ForegroundIndex;
};


#endif
