/* KinokoControlWidget.cc */
/* Created by Enomoto Sanshiro on 30 September 2001. */
/* Last updated by Enomoto Sanshiro on 7 April 2007. */


#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include "KinokoControlWidget.hh"

using namespace std;



TKinokoControlWidget::TKinokoControlWidget(const string& Type, const string& Name)
{
    _Type = Type;
    _Name = Name;

    _IsDisabled = false;
}

TKinokoControlWidget::~TKinokoControlWidget()
{
}

string TKinokoControlWidget::Type(void)
{
    return _Type;
}

string TKinokoControlWidget::Name(void)
{
    return _Name;
}

bool TKinokoControlWidget::SetAttribute(const std::string& Name, const std::string& Value)
{
    return false;
}

bool TKinokoControlWidget::GetAttribute(const std::string& Name, std::string& Value)
{
    return false;
}

void TKinokoControlWidget::Enable(void)
{
    _IsDisabled = false;
}

void TKinokoControlWidget::Disable(void)
{
    _IsDisabled = true;
}

bool TKinokoControlWidget::IsDisabled(void)
{
    return _IsDisabled;
}

string TKinokoControlWidget::ActionOnClick(void)
{
    return _ActionOnClick;
}

string TKinokoControlWidget::ActionOnFocus(void)
{
    return _ActionOnFocus;
}

string TKinokoControlWidget::ActionOnBlur(void)
{
    return _ActionOnBlur;
}



TKinokoButtonWidget::TKinokoButtonWidget(const string& Name, const string& ActionOnClick)
: TKinokoControlWidget("Button", Name)
{
    _ActionOnClick = ActionOnClick;
}

TKinokoButtonWidget::~TKinokoButtonWidget()
{
}

string TKinokoButtonWidget::Value(void)
{
    return "";
}

void TKinokoButtonWidget::SetValue(const string& Value)
{
}



TKinokoLabelWidget::TKinokoLabelWidget(const string& Name)
: TKinokoControlWidget("Label", Name)
{
}

TKinokoLabelWidget::~TKinokoLabelWidget()
{
}


TKinokoEntryWidget::TKinokoEntryWidget(const string& Name)
: TKinokoControlWidget("Entry", Name)
{
}


TKinokoEntryWidget::~TKinokoEntryWidget()
{
}

void TKinokoEntryWidget::SetActionOnFocus(const std::string& Action)
{
    _ActionOnFocus = Action;
}

void TKinokoEntryWidget::SetActionOnBlur(const std::string& Action)
{
    _ActionOnBlur = Action;
}



TKinokoTextBoxWidget::TKinokoTextBoxWidget(const string& Name)
: TKinokoControlWidget("TextBox", Name)
{
}

TKinokoTextBoxWidget::~TKinokoTextBoxWidget()
{
}



TKinokoCheckButtonWidget::TKinokoCheckButtonWidget(const string& Name)
: TKinokoControlWidget("CheckButton", Name)
{
}

TKinokoCheckButtonWidget::~TKinokoCheckButtonWidget()
{
}


TKinokoRadioButtonWidget::TKinokoRadioButtonWidget(const string& Name)
: TKinokoControlWidget("RadioButton", Name)
{
}

TKinokoRadioButtonWidget::~TKinokoRadioButtonWidget()
{
}


TKinokoRadioButtonSetWidget::TKinokoRadioButtonSetWidget(const string& Name)
: TKinokoControlWidget("RadioButtonSet", Name)
{
}

TKinokoRadioButtonSetWidget::~TKinokoRadioButtonSetWidget()
{
    for (unsigned i = 0; i < _RadioButtonList.size(); i++) {
	delete _RadioButtonList[i];
    }
}

void TKinokoRadioButtonSetWidget::AddRadioButton(TKinokoRadioButtonWidget* RadioButtonWidget)
{
    _RadioButtonList.push_back(RadioButtonWidget);
    _RadioButtonTable[RadioButtonWidget->Name()] = RadioButtonWidget;
}

string TKinokoRadioButtonSetWidget::Value(void)
{
    string Result;
    for (unsigned i = 0; i < _RadioButtonList.size(); i++) {
	if (_RadioButtonList[i]->Value() == "1") {
	    Result = _RadioButtonList[i]->Name();
	    break;
	}
    }

    return Result;
}

void TKinokoRadioButtonSetWidget::SetValue(const string& Value)
{
    if (_RadioButtonTable.count(Value) > 0) {
	_RadioButtonTable[Value]->SetValue("1");
    }
}

void TKinokoRadioButtonSetWidget::Enable(void)
{
    for (unsigned i = 0; i < _RadioButtonList.size(); i++) {
	_RadioButtonList[i]->Disable();
    }

    TKinokoControlWidget::Enable();
}

void TKinokoRadioButtonSetWidget::Disable(void)
{
    for (unsigned i = 0; i < _RadioButtonList.size(); i++) {
	_RadioButtonList[i]->Disable();
    }

    TKinokoControlWidget::Disable();
}



TKinokoNotebookWidget::TKinokoNotebookWidget(const std::string& Name)
: TKinokoControlWidget("Notebook", Name)
{
}


TKinokoNotebookWidget::~TKinokoNotebookWidget()
{
}



TKinokoMenuItemWidget::TKinokoMenuItemWidget(const string& Name, const string& ActionOnClick)
: TKinokoControlWidget("MenuItem", Name)
{
    _ActionOnClick = ActionOnClick;
}

TKinokoMenuItemWidget::~TKinokoMenuItemWidget()
{
}

string TKinokoMenuItemWidget::Value(void)
{
    return "[MenuItem]";
}

void TKinokoMenuItemWidget::SetValue(const string& Value)
{
}



TKinokoConstantWidget::TKinokoConstantWidget(const string& Name, const string& Value)
: TKinokoControlWidget("Constant", Name)
{
    _Value = Value;
}

TKinokoConstantWidget::~TKinokoConstantWidget()
{
}

string TKinokoConstantWidget::Value(void)
{
    return _Value;
}

void TKinokoConstantWidget::SetValue(const string& Value)
{
    _Value = Value;
}

void TKinokoConstantWidget::Enable(void)
{
    TKinokoControlWidget::Enable();
}

void TKinokoConstantWidget::Disable(void)
{
    TKinokoControlWidget::Disable();
}


void TKinokoControlImagePort::Initialize(void)
{
}

void TKinokoControlImagePort::Redraw(void)
{
    GetImageArea()->Redraw();
}


TKinokoControlVisualWidget::TKinokoControlVisualWidget(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort)
: TKinokoControlWidget("Visual", Name)
{
    _ActionOnClick = OptionTable["on_click"];
    if (_ActionOnClick.empty()) {
	_ActionOnClick = " ";
    }

    _ImagePort = ImagePort;

    _FontName = OptionTable["font"];
    if (_FontName.empty()) {
	_FontName = "helvetica";
    }
    if (! (istringstream(OptionTable["fontsize"]) >> _FontSize)) {
	_FontSize = 16;
    }

    _Value = OptionTable["value"];
}

TKinokoControlVisualWidget::~TKinokoControlVisualWidget()
{
    delete _ImagePort;
}

int TKinokoControlVisualWidget::DefaultWidth(void)
{
    return 120;
}

int TKinokoControlVisualWidget::DefaultHeight(void)
{
    return 40;
}

bool TKinokoControlVisualWidget::AddDecoration(const std::string& Name, std::map<std::string, std::string>& OptionTable)
{
    return false;
}

void TKinokoControlVisualWidget::Enable(void)
{
    TKinokoControlWidget::Enable();
}

void TKinokoControlVisualWidget::Disable(void)
{
    TKinokoControlWidget::Disable();
}

void TKinokoControlVisualWidget::Initialize(void)
{
    _ImagePort->Initialize();

    _ImageArea = _ImagePort->GetImageArea();
    _Width = _ImageArea->Width();
    _Height = _ImageArea->Height();

    _WhiteIndex = _ImageArea->AllocateColor("white");
    _BlackIndex = _ImageArea->AllocateColor("black");

    _ImageArea->SetFont(_ImageArea->LoadFont(_FontName, _FontSize));
}

string TKinokoControlVisualWidget::DecodeColorValue(const std::string& Value)
{
    string Color;

    if (Value.empty() || (Value == "0") || (Value == "off")) {
	Color = "rgb:808080";
    }
    else if ((Value == "1") || (Value == "on")) {
	Color = "rgb:ffe499";
    }
    else if ((Value == "2") || (Value == "good")) {
	Color = "rgb:00ff00";
    }
    else if ((Value == "3") || (Value == "error")) {
	Color = "rgb:ff0000";
    }
    else if ((Value == "4") || (Value == "red-on")) {
	Color = "rgb:ff0000";
    }
    else if ((Value == "5") || (Value == "green-on")) {
	Color = "rgb:00ff00";
    }
    else if ((Value == "6") || (Value == "yellow-on")) {
	Color = "rgb:ffff00";
    }
    else if ((Value == "7") || (Value == "red-off")) {
	Color = "rgb:b95959";
    }
    else if ((Value == "8") || (Value == "green-off")) {
	Color = "rgb:5c825c";
    }
    else if ((Value == "9") || (Value == "yellow-off")) {
	Color = "rgb:b2b247";
    }
    else {
	return Value;
    }

    return Color;
}

void TKinokoControlVisualWidget::Redraw(void)
{
    _ImagePort->Redraw();
}

std::string TKinokoControlVisualWidget::Value(void)
{
    return _Value;
}

void TKinokoControlVisualWidget::OnButtonPress(int ButtonNumber)
{
}

void TKinokoControlVisualWidget::OnButtonRelease(int ButtonNumber)
{
}
