/* KinokoControlWidget.hh */
/* Created by Enomoto Sanshiro on 30 September 2001. */
/* Last updated by Enomoto Sanshiro on 1 May 2007. */


#ifndef __KinokoControlWidget_hh
#define __KinokoControlWidget_hh


#include <string>
#include <vector>
#include <map>
#include "KinokoCanvasImageArea.hh"


class TKinokoControlWidget {
  public:
    TKinokoControlWidget(const std::string& Type, const std::string& Name);
    virtual ~TKinokoControlWidget();
    virtual std::string Type(void);
    virtual std::string Name(void);
    virtual std::string ActionOnClick(void);
    virtual std::string ActionOnFocus(void);
    virtual std::string ActionOnBlur(void);
    virtual void Enable(void);
    virtual void Disable(void);
    virtual bool IsDisabled(void);
    virtual std::string Value(void) = 0;
    virtual void SetValue(const std::string& Value) = 0;
    virtual bool SetAttribute(const std::string& Name, const std::string& Value);
    virtual bool GetAttribute(const std::string& Name, std::string& Value);
    virtual void Initialize(void) {}
    virtual void Redraw(void) {}
  protected:
    std::string _Type, _Name;
    std::string _ActionOnClick, _ActionOnFocus, _ActionOnBlur;
    bool _IsDisabled;
};


class TKinokoButtonWidget: public TKinokoControlWidget {
  public:
    TKinokoButtonWidget(const std::string& Name, const std::string& ActionOnClick = "");
    virtual ~TKinokoButtonWidget();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
};


class TKinokoLabelWidget: public TKinokoControlWidget {
  public:
    TKinokoLabelWidget(const std::string& Name);
    virtual ~TKinokoLabelWidget();
};


class TKinokoEntryWidget: public TKinokoControlWidget {
  public:
    TKinokoEntryWidget(const std::string& Name);
    virtual ~TKinokoEntryWidget();
    virtual void SetActionOnFocus(const std::string& Action);
    virtual void SetActionOnBlur(const std::string& Action);
};


class TKinokoTextBoxWidget: public TKinokoControlWidget {
  public:
    TKinokoTextBoxWidget(const std::string& Name);
    virtual ~TKinokoTextBoxWidget();
};


class TKinokoCheckButtonWidget: public TKinokoControlWidget {
  public:
    TKinokoCheckButtonWidget(const std::string& Name);
    virtual ~TKinokoCheckButtonWidget();
};


class TKinokoRadioButtonWidget: public TKinokoControlWidget {
  public:
    TKinokoRadioButtonWidget(const std::string& Name);
    virtual ~TKinokoRadioButtonWidget();
};


class TKinokoRadioButtonSetWidget: public TKinokoControlWidget {
  public:
    TKinokoRadioButtonSetWidget(const std::string& Name);
    virtual ~TKinokoRadioButtonSetWidget();
    virtual void AddRadioButton(TKinokoRadioButtonWidget* RadioButtonWidget);
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    std::vector<TKinokoRadioButtonWidget*> _RadioButtonList;
    std::map<std::string, TKinokoRadioButtonWidget*> _RadioButtonTable;
};


class TKinokoNotebookWidget: public TKinokoControlWidget {
  public:
    TKinokoNotebookWidget(const std::string& Name);
    virtual ~TKinokoNotebookWidget();
};


class TKinokoMenuItemWidget: public TKinokoControlWidget {
  public:
    TKinokoMenuItemWidget(const std::string& Name, const std::string& ActionOnClick = "");
    virtual ~TKinokoMenuItemWidget();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
};


class TKinokoConstantWidget: public TKinokoControlWidget {
  public:
    TKinokoConstantWidget(const std::string& Name, const std::string& Value);
    virtual ~TKinokoConstantWidget();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    std::string _Value;
};


class TKinokoControlImagePort {
  public:
    TKinokoControlImagePort(void) {}
    virtual ~TKinokoControlImagePort() {}
    virtual void Initialize(void);
    virtual void Redraw(void);
    virtual TKinokoCanvasImageArea* GetImageArea(void) = 0;
};


class TKinokoControlVisualWidget: public TKinokoControlWidget {
  public:
    TKinokoControlVisualWidget(const std::string& Name, std::map<std::string, std::string>& OptionTable, TKinokoControlImagePort* ImagePort);
    virtual ~TKinokoControlVisualWidget();
    virtual int DefaultWidth(void);
    virtual int DefaultHeight(void);
    virtual bool AddDecoration(const std::string& Name, std::map<std::string, std::string>& OptionTable);
    virtual void Enable(void);
    virtual void Disable(void);
    virtual std::string Value(void);
    virtual void Initialize(void);
    virtual void Redraw(void);
    virtual void OnButtonPress(int ButtonNumber);
    virtual void OnButtonRelease(int ButtonNumber);
  protected:
    virtual std::string DecodeColorValue(const std::string& Value);
  protected:
    TKinokoControlImagePort* _ImagePort;
    TKinokoCanvasImageArea* _ImageArea;
    float _Width, _Height;
    std::string _FontName;
    int _FontSize;
    int _WhiteIndex, _BlackIndex;
    std::string _Value;
};


#endif
