/* KinokoShell.hh */
/* Created by Enomoto Sanshiro on 27 March 2002. */
/* Last updated by Enomoto Sanshiro on 27 March 2002. */


#ifndef __KinokoShell_hh
#define __KinokoShell_hh


#include <iostream>
#include <string>
#include <map>
#include "KinokoShellConnector.hh"
#include "KinokoShellPopupWindow.hh"
#include "KinokoShellFileSelectDialog.hh"


class TKinokoShellException {
  protected:
    std::string _Message;
  public:
    TKinokoShellException(std::string Location, std::string Message);
    TKinokoShellException(std::string Message);
    TKinokoShellException(const TKinokoShellException &e);
    std::string Message(void) const;
    friend std::ostream& operator<< (std::ostream &os, const TKinokoShellException &e);
};


class TKinokoShellObject;

class TKinokoShell {
  public:
    TKinokoShell(TKinokoShellConnector* ShellConnector);
    virtual ~TKinokoShell();
    virtual int ProcessInput(void);
    virtual int ProcessCommandLine(const char* CommandLine);
    virtual void Start(void) = 0;
    virtual void Quit(void) = 0;
    virtual void Detach(void) {}
    virtual bool TryToQuit(void);
    virtual bool IsRunnung(void);
  protected:
    virtual void ConstructPrototypeTable(void) {}
    virtual void RegisterObjectPrototype(const std::string& ClassName, TKinokoShellObject* ObjectPrototype);
    virtual int ProcessSystemCommand(const std::string& Command, std::istream& InputStream);
    virtual int ProcessCommand(std::istream& InputStream);
    virtual int ProcessCreateCommand(std::istream& InputStream);
  protected:
    virtual TKinokoShellPopupWindow* CreatePopupWindow(void) = 0;
    virtual TKinokoShellFileSelectDialog* CreateFileSelectDialog(void) = 0;
  protected:
    TKinokoShellConnector* _ShellConnector;
    bool _IsConstructed, _IsRunning;
    std::map<std::string, TKinokoShellObject*> _PrototypeTable;
    std::map<std::string, TKinokoShellObject*> _ObjectTable;
};


class TKinokoShellObject {
  public:
    TKinokoShellObject(void);
    virtual ~TKinokoShellObject();
    virtual TKinokoShellObject* Clone(void) = 0;
    virtual void SetName(const std::string& ObjectName);
    virtual const std::string& Name(void);
    virtual void Initialize(void);
    virtual int Construct(std::istream& InputStream);
    virtual int ProcessCommand(const std::string& Command, std::istream& InputStream) = 0;
  protected:
    std::string _ObjectName;
};


#endif
