/* KinokoShellScript.hh */
/* Created by Enomoto Sanshiro on 19 December 2002. */
/* Last updated by Enomoto Sanshiro on 19 December 2002. */


#ifndef __KinokoShellScript_hh__
#define __KinokoShellScript_hh__


#include "ParaParser.hh"
#include "KinokoShellPopupWindow.hh"
#include "KinokoShellFileSelectDialog.hh"


class TKinokoShellScript: public TParaStandardParser {
  public:
    TKinokoShellScript(TKinokoShellPopupWindow* PopupWindow, TKinokoShellFileSelectDialog* FileSelectDialog);
    virtual ~TKinokoShellScript();
  protected:
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
    virtual TParaPackage* CreatePackage(void);
  protected:
    TKinokoShellPopupWindow* _PopupWindow;
    TKinokoShellFileSelectDialog* _FileSelectDialog;
};


class TKinokoShellPopupWindowMessenger: public TParaObjectPrototype {
  public:
    TKinokoShellPopupWindowMessenger(TKinokoShellPopupWindow* ShellPopupWindow);
    virtual ~TKinokoShellPopupWindowMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int OpenPopup(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue, bool IsModal) throw(TScriptException);
  protected:
    enum {
	MethodId_OpenPopup = TParaObjectPrototype::_NumberOfMethods,
	MethodId_OpenQueryPopup,
	_NumberOfMethods
    };
  protected:
    TKinokoShellPopupWindow* _PopupWindow;
};


class TKinokoShellFileSelectDialogMessenger: public TParaObjectPrototype {
  public:
    TKinokoShellFileSelectDialogMessenger(TKinokoShellFileSelectDialog* ShellFileSelectDialog);
    virtual ~TKinokoShellFileSelectDialogMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int OpenFileSelectDialog(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_OpenFileSelectDialog = TParaObjectPrototype::_NumberOfMethods,
	_NumberOfMethods
    };
  protected:
    TKinokoShellFileSelectDialog* _FileSelectDialog;
};


#endif
