/* KinokoBoardGtk.cc */
/* Created by Enomoto Sanshiro on 29 October 2001. */
/* Last updated by Enomoto Sanshiro on 29 October 2001. */


#include <string>
#include <gtk/gtk.h>
#include "KinokoShellConnector.hh"
#include "KinokoBoardGtk.hh"
#include "KinokoCanvasTextAreaGtk.hh"
#include "KinokoShellPopupWindowGtk.hh"
#include "KinokoShellFileSelectDialogGtk.hh"
#include "KinokoShellAboutDialogGtk.hh"
#include "KinokoShellConfig.hh"

#include "NaviPause.xpm"
#include "NaviGo.xpm"
#include "NaviForeward.xpm"
#include "NaviBackward.xpm"


using namespace std;


static TKinokoBoardGtk* g_Board = 0;
static gint g_InputTag;
static GdkPixmap* GoPixmapData;
static GdkBitmap* GoPixmapMask;
static GdkPixmap* PausePixmapData;
static GdkBitmap* PausePixmapMask;
static GtkWidget* GoPauseButtonPixmap;

static gint delete_event_cb(GtkWidget* Widget, GdkEventAny* Event, gpointer Data);
static void input_event_cb(gpointer Data, gint File, GdkInputCondition Condition);

static void menu_save_cb(void);
static void menu_quit_cb(void);
static void menu_about_cb(void);
static void gopause_button_clicked_cb(GtkWidget* Widget, gpointer Data);
static void jumptop_button_clicked_cb(GtkWidget* Widget, gpointer Data);
static void jumpbottom_button_clicked_cb(GtkWidget* Widget, gpointer Data);


static GtkItemFactoryEntry MenuItemList[] = {
    {"/_File",          NULL,         0,             0, "<Branch>"},
    {"/File/_Save...",  NULL,         menu_save_cb,  0, "<Item>"},
    {"/File/",          NULL,         0,             0, "<Separator>"},
    {"/File/e_Xit",     "<control>X", menu_quit_cb,  0, "<Item>"},
    {"/_Help",          NULL,         0,             0, "<Branch>"},
    {"/Help/_About...", NULL,         menu_about_cb, 0, "<Item>"}
};
static gint NumberOfMenuItems = sizeof(MenuItemList) / sizeof(MenuItemList[0]);



TKinokoBoardGtk::TKinokoBoardGtk(TKinokoShellConnector* ShellConnector, int argc, char** argv, int Width, int Height)
: TKinokoBoard(ShellConnector)
{
    _Width = Width;
    _Height = Height;
    
    gtk_init(&argc, &argv);
}

TKinokoBoardGtk::~TKinokoBoardGtk()
{
}

TKinokoShellPopupWindow* TKinokoBoardGtk::CreatePopupWindow(void)
{
    return new TKinokoShellPopupWindowGtk();
}

TKinokoShellFileSelectDialog* TKinokoBoardGtk::CreateFileSelectDialog(void)
{
    return new TKinokoShellFileSelectDialogGtk();
}

void TKinokoBoardGtk::Start(void)
{
    if (g_Board == 0) {
	g_Board = this;
	Construct();

	Initialize(new TKinokoCanvasTextAreaGtk(_TextWidget));
    }

    gtk_main();
}

void TKinokoBoardGtk::Quit(void)
{
    gtk_main_quit();
}

void TKinokoBoardGtk::Construct(void)
{
    _RootWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    // Menu and Menubar //
    GtkAccelGroup* AccelGroup = gtk_accel_group_new();
    GtkItemFactory* ItemFactory = gtk_item_factory_new(
	GTK_TYPE_MENU_BAR, "<menu>", AccelGroup
    );
    gtk_item_factory_create_items(
	ItemFactory, NumberOfMenuItems, MenuItemList, NULL
    );
    gtk_window_add_accel_group(GTK_WINDOW(_RootWindow), AccelGroup);
    GtkWidget* MenuHandleBox = gtk_handle_box_new();
    GtkWidget* Menu = gtk_item_factory_get_widget(ItemFactory, "<menu>");
    gtk_container_add(GTK_CONTAINER(MenuHandleBox), Menu);

    // Control Box //
    GtkWidget* ControlHandleBox = gtk_handle_box_new();
    GtkWidget* ControlBox = gtk_hbox_new(FALSE, 0);
    GtkWidget* GoPauseButton = gtk_button_new();
    GtkWidget* JumpTopButton = gtk_button_new();
    GtkWidget* JumpBottomButton = gtk_button_new();
    GtkTooltips* GoPauseButtonTip = gtk_tooltips_new();
    GtkTooltips* JumpTopButtonTip = gtk_tooltips_new();
    GtkTooltips* JumpBottomButtonTip = gtk_tooltips_new();
    gtk_tooltips_set_tip(GoPauseButtonTip, GoPauseButton, "freeze/thaw display", NULL);
    gtk_tooltips_set_tip(JumpTopButtonTip, JumpTopButton, "jump to first", NULL);
    gtk_tooltips_set_tip(JumpBottomButtonTip, JumpBottomButton, "jump to last", NULL);
    gtk_box_pack_start(GTK_BOX(ControlBox), GoPauseButton, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(ControlBox), JumpTopButton, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(ControlBox), JumpBottomButton, FALSE, FALSE, 0);
    gtk_container_add(GTK_CONTAINER(ControlHandleBox), ControlBox);

    // Message Frame //
    GtkWidget* MessageHBox = gtk_hbox_new(FALSE, 0);
    _TextWidget = gtk_text_new(NULL, NULL);
    GtkWidget* Scrollbar = gtk_vscrollbar_new(GTK_TEXT(_TextWidget)->vadj);
    gtk_text_set_editable(GTK_TEXT(_TextWidget), FALSE);
    gtk_box_pack_start(GTK_BOX(MessageHBox), _TextWidget, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(MessageHBox), Scrollbar, FALSE, FALSE, 0);
    gtk_widget_set_usize(_TextWidget, _Width, _Height);

    // Status Bar //
    GtkWidget* StatusBarHandleBox = gtk_handle_box_new();
    GtkWidget* StatusBarHBox = gtk_hbox_new(FALSE, 0);
    _StatusBarEntryWidget = gtk_entry_new();
    gtk_entry_set_editable(GTK_ENTRY(_StatusBarEntryWidget), FALSE);
    gtk_box_pack_start(GTK_BOX(StatusBarHBox), _StatusBarEntryWidget, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(StatusBarHandleBox), StatusBarHBox);

    // Packing and Show //
    GtkWidget* VBox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(_RootWindow), VBox);
    gtk_box_pack_start(GTK_BOX(VBox), MenuHandleBox, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(VBox), ControlHandleBox, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(VBox), MessageHBox, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(VBox), StatusBarHandleBox, FALSE, FALSE, 0);
    gtk_widget_show_all(_RootWindow);

    // Control Box Images //
    PausePixmapData = gdk_pixmap_create_from_xpm_d(
	_RootWindow->window, &PausePixmapMask, NULL, NaviPause_xpm
    );
    GoPixmapData = gdk_pixmap_create_from_xpm_d(
	_RootWindow->window, &GoPixmapMask, NULL, NaviGo_xpm
    );
    GoPauseButtonPixmap = gtk_pixmap_new(PausePixmapData, PausePixmapMask);
    gtk_widget_show(GoPauseButtonPixmap);
    gtk_container_add(GTK_CONTAINER(GoPauseButton), GoPauseButtonPixmap);

    GdkBitmap* Mask;
    GdkPixmap* PixmapData;
    PixmapData = gdk_pixmap_create_from_xpm_d(
	_RootWindow->window, &Mask, NULL, NaviBackward_xpm
    );
    GtkWidget* JumpTopPixmap = gtk_pixmap_new(PixmapData, Mask);
    gtk_widget_show(JumpTopPixmap);
    gtk_container_add(GTK_CONTAINER(JumpTopButton), JumpTopPixmap);

    PixmapData = gdk_pixmap_create_from_xpm_d(
	_RootWindow->window, &Mask, NULL, NaviForeward_xpm
    );
    GtkWidget* JumpBottomPixmap = gtk_pixmap_new(PixmapData, Mask);
    gtk_widget_show(JumpBottomPixmap);
    gtk_container_add(GTK_CONTAINER(JumpBottomButton), JumpBottomPixmap);

    // Event Handler Connection //
    gtk_signal_connect(
	GTK_OBJECT(_RootWindow), "delete_event", 
	GTK_SIGNAL_FUNC(delete_event_cb), NULL
    );

    g_InputTag = gdk_input_add(
	_ShellConnector->FileDescriptor(),
	(GdkInputCondition) (GDK_INPUT_READ | GDK_INPUT_EXCEPTION), 
	input_event_cb, NULL
    );

    gtk_signal_connect(
	GTK_OBJECT(GoPauseButton), "clicked",
	GTK_SIGNAL_FUNC(gopause_button_clicked_cb), this
    );
    gtk_signal_connect(
	GTK_OBJECT(JumpTopButton), "clicked",
	GTK_SIGNAL_FUNC(jumptop_button_clicked_cb), this
    );
    gtk_signal_connect(
	GTK_OBJECT(JumpBottomButton), "clicked",
	GTK_SIGNAL_FUNC(jumpbottom_button_clicked_cb), this
    );
}

void TKinokoBoardGtk::SetTitle(const string& Title)
{
    gtk_window_set_title(GTK_WINDOW(_RootWindow), Title.c_str());
}

void TKinokoBoardGtk::WriteStatusMessage(const string& Message)
{
    gtk_entry_set_text(GTK_ENTRY(_StatusBarEntryWidget), Message.c_str());
}



static gint delete_event_cb(GtkWidget* Widget, GdkEventAny* Event, gpointer Data)
{
    bool Result = g_Board->TryToQuit();
    return Result ? FALSE : TRUE;
}

static void input_event_cb(gpointer Data, gint File, GdkInputCondition Condition)
{
    if (g_Board == 0) {
	return;
    }

    int ProcessedLength = 0;
    if (Condition == GDK_INPUT_READ) {
	ProcessedLength = g_Board->ProcessInput();
    }
    
    if ((Condition == GDK_INPUT_EXCEPTION) || (ProcessedLength <= 0)) {
	gdk_input_remove(g_InputTag);
    }
}

static void menu_save_cb(void)
{
    TKinokoShellFileSelectDialogGtk FileSelectDialog("Save");

    string FileName = FileSelectDialog.Open();
    if (! FileName.empty()) {
	g_Board->SaveTo(FileName);
    }
}

static void menu_quit_cb(void)
{
    g_Board->TryToQuit();
}

static void menu_about_cb(void)
{
    TKinokoShellAboutDialogGtk AboutDialog;

    AboutDialog.SetTitle("Kinoko Board " KINOKO_SHELL_VERSION);
    AboutDialog.SetCopyright(KINOKO_SHELL_COPYING);
    AboutDialog.AddAuthor(KINOKO_SHELL_AUTHOR);
    AboutDialog.AddComment("Remotely writable text display");

    AboutDialog.Open();
}

static void gopause_button_clicked_cb(GtkWidget* Widget, gpointer Data)
{
    TKinokoBoard* Board = (TKinokoBoard*) Data;
    
    if (! Board->IsScrollingFrozen()) {
	Board->FreezeScrolling();
	gtk_pixmap_set(
	    GTK_PIXMAP(GoPauseButtonPixmap), GoPixmapData, GoPixmapMask
	);
    }
    else {
	Board->ThawScrolling();
	gtk_pixmap_set(
	    GTK_PIXMAP(GoPauseButtonPixmap), PausePixmapData, PausePixmapMask
	);
    }
}

static void jumptop_button_clicked_cb(GtkWidget* Widget, gpointer Data)
{
    ((TKinokoBoard*) Data)->ScrollToTop();
}

static void jumpbottom_button_clicked_cb(GtkWidget* Widget, gpointer Data)
{
    ((TKinokoBoard*) Data)->ScrollToBottom();
}
