/* KinokoCanvasTextAreaGtk.hh */
/* Created by Enomoto Sanshiro on 9 July 2000. */
/* Last updated by Enomoto Sanshiro on 9 July 2000. */


#ifndef __KinokoCanvasTextAreaGtk_hh
#define __KinokoCanvasTextAreaGtk_hh


#include <string>
#include <vector>
#include <gtk/gtk.h>
#include "KinokoCanvas.hh"
#include "KinokoCanvasTextArea.hh"
#include "KinokoCanvasImageArea.hh"


class TKinokoCanvasTextAreaGtk: public TKinokoCanvasTextArea {
  public:
    TKinokoCanvasTextAreaGtk(GtkWidget* Text);
    virtual ~TKinokoCanvasTextAreaGtk();
    virtual void Clear(void);
    virtual void PutLine(const std::string& Line);
    virtual int AllocateColor(float Red, float Green, float Blue);
    virtual int SetTextColor(int ColorIndex);
    virtual int LoadFont(const std::string& FontNameString);
    virtual int SetFont(int FontIndex);
  public:
    virtual void SetEditable(bool IsEditable);
    virtual void ScrollToTop(void);
    virtual void ScrollToBottom(void);
    virtual void FreezeScrolling(void);
    virtual void ThawScrolling(void);
  protected:
    GtkWidget* _Text;
    GdkColor* _TextColor;
    std::vector<GdkColor*> _ColorList;
    GdkFont* _CurrentFont;
    std::vector<GdkFont*> _FontList;
};


#endif

