/* KinokoControlGtk.cc */
/* Created by Enomoto Sanshiro on 1 October 2001. */
/* Last updated by Enomoto Sanshiro on 1 October 2001. */


#include <string>
#include <gtk/gtk.h>
#include "MushFileSystem.hh"
#include "KinokoShellConnector.hh"
#include "KinokoShellPopupWindowGtk.hh"
#include "KinokoShellFileSelectDialogGtk.hh"
#include "KinokoControlPanelScript.hh"
#include "KinokoControlWidgetGtk.hh"
#include "KinokoControlPanelGtk.hh"
#include "KinokoControlGtk.hh"

using namespace std;


static TKinokoControl* g_Control = 0;
static gint g_InputTag;

static void input_event_cb(gpointer Data, gint File, GdkInputCondition Condition);
static gint timeout_event_cb(gpointer Data);


TKinokoControlGtk::TKinokoControlGtk(TKinokoShellConnector* ShellConnector, int argc, char** argv)
: TKinokoControl(ShellConnector)
{
    _ControlPanelScript = 0;
    _ControlPanel = 0;

    gtk_init(&argc, &argv);
}

TKinokoControlGtk::~TKinokoControlGtk()
{
    delete _ControlPanel;
    delete _ControlPanelScript;
}

TKinokoShellPopupWindow* TKinokoControlGtk::CreatePopupWindow(void)
{
    return new TKinokoShellPopupWindowGtk();
}

TKinokoShellFileSelectDialog* TKinokoControlGtk::CreateFileSelectDialog(void)
{
    return new TKinokoShellFileSelectDialogGtk();
}

void TKinokoControlGtk::Start(void)
{
    if (g_Control == 0) {
	g_Control = this;

	g_InputTag = gdk_input_add(
	    _ShellConnector->FileDescriptor(),
	    (GdkInputCondition) (GDK_INPUT_READ | GDK_INPUT_EXCEPTION), 
	    input_event_cb, NULL
	);

	gtk_timeout_add(1000, timeout_event_cb, this);
    }

    gtk_main();
}

void TKinokoControlGtk::Quit(void)
{
    OnShutdown();
    gtk_main_quit();
}

void TKinokoControlGtk::Detach(void)
{
    //... not implemented yet ...//
}

void TKinokoControlGtk::HandleException(const TKinokoShellException& Exception)
{
    cerr << "ERROR: " << Exception << endl;
}

void TKinokoControlGtk::Construct(const string& ScriptFileName)
{
    string RootPath = TMushFileAttribute(ScriptFileName).PathName();
    _ControlPanel = new TKinokoControlPanelGtk(this, RootPath);

    _ControlPanelScript = new TKinokoXmlControlPanelScript(
	_ControlPanel, ScriptFileName
    );

    _ControlPanelScript->Go();

    InitializeWidgets();
    OnStartup();
}

static void input_event_cb(gpointer Data, gint File, GdkInputCondition Condition)
{
    if (g_Control == 0) {
	return;
    }

    int ProcessedLength = 0;
    if (Condition == GDK_INPUT_READ) {
	ProcessedLength = g_Control->ProcessInput();
    }
    
    if ((Condition == GDK_INPUT_EXCEPTION) || (ProcessedLength <= 0)) {
	gdk_input_remove(g_InputTag);
    }
}

static gint timeout_event_cb(gpointer Data)
{
    ((TKinokoControlGtk*) Data)->OnEverySecond();
    return 1;
}
