/* KinokoControlPanelGtk.hh */
/* Created by Enomoto Sanshiro on 28 September 2001. */
/* Last updated by Enomoto Sanshiro on 28 September 2001. */


#ifndef __KinokoControlPanelGtk_hh
#define __KinokoControlPanelGtk_hh


#include <string>
#include <vector>
#include <deque>
#include <gtk/gtk.h>
#include "KinokoControlWidgetGtk.hh"
#include "KinokoControlPanel.hh"
#include "KinokoControlVisualWidget.hh"


class TKinokoControlPanelGtk: public TKinokoControlPanel {
  public:
    TKinokoControlPanelGtk(TKinokoControl* Control, const std::string& RootPath = "");
    virtual ~TKinokoControlPanelGtk();
    virtual void OpenPanel(std::map<std::string, std::string>& OptionTable);
    virtual void ClosePanel(void);
    virtual void OpenFrame(std::map<std::string, std::string>& OptionTable);
    virtual void CloseFrame(void);
    virtual void OpenBox(std::map<std::string, std::string>& OptionTable);
    virtual void CloseBox(void);
    virtual void OpenNotebook(std::map<std::string, std::string>& OptionTable);
    virtual void CloseNotebook(void);
    virtual void OpenPage(std::map<std::string, std::string>& OptionTable);
    virtual void ClosePage(void);
    virtual void OpenTable(std::map<std::string, std::string>& OptionTable);
    virtual void CloseTable(void);
    virtual void OpenCell(std::map<std::string, std::string>& OptionTable);
    virtual void CloseCell(void);
    virtual void OpenToolBar(std::map<std::string, std::string>& OptionTable);
    virtual void CloseToolBar(void);
    virtual void OpenEntryList(std::map<std::string, std::string>& OptionTable);
    virtual void CloseEntryList(void);
    virtual void AddEntry(std::map<std::string, std::string>& OptionTable);
    virtual void OpenButtonList(std::map<std::string, std::string>& OptionTable);
    virtual void CloseButtonList(void);
    virtual void AddButton(std::map<std::string, std::string>& OptionTable);
    virtual void OpenCheckButtonList(std::map<std::string, std::string>& OptionTable);
    virtual void CloseCheckButtonList(void);
    virtual void AddCheckButton(std::map<std::string, std::string>& OptionTable);
    virtual void OpenRadioButtonList(std::map<std::string, std::string>& OptionTable);
    virtual void CloseRadioButtonList(void);
    virtual void AddRadioButton(std::map<std::string, std::string>& OptionTable);
    virtual void OpenMenu(std::map<std::string, std::string>& OptionTable);
    virtual void CloseMenu(void);
    virtual void AddMenuItem(std::map<std::string, std::string>& OptionTable);
    virtual void AddLabel(std::map<std::string, std::string>& OptionTable);
    virtual void AddTextBox(std::map<std::string, std::string>& OptionTable);
    virtual void AddImage(std::map<std::string, std::string>& OptionTable);
    virtual void AddVSpace(std::map<std::string, std::string>& OptionTable);
    virtual void AddHSpace(std::map<std::string, std::string>& OptionTable);
    virtual void AddNewLine(std::map<std::string, std::string>& OptionTable);
    virtual void AddViewlet(const std::string& ViewletTypeName, std::map<std::string, std::string>& OptionTable);
    virtual TKinokoControlVisualWidget* AddVisualWidget(TKinokoControlVisualWidgetCreator* Creator, std::map<std::string, std::string>& OptionTable);
  protected:
    virtual void CreateRootWindow(void);
  protected:
    GtkWidget* _RootWindow;
    GtkItemFactory* _ItemFactory;
    GtkWidget* _ToolBar;
    GtkWidget* _ToolBarHBox;
    GtkWidget* _CurrentFrame;
    GtkWidget* _CurrentVBox;
    GtkWidget* _CurrentHBox;
    std::deque<GtkWidget*> _FrameStack;
    std::deque<GtkWidget*> _VBoxStack;
    std::deque<GtkWidget*> _HBoxStack;
    std::deque<GtkWidget*> _NotebookStack;
    std::deque<GtkWidget*> _TableStack;
    std::deque<std::pair<int, int> > _TableSizeStack;
    std::deque<std::pair<int, int> > _TablePositionStack;
    std::vector<GtkWidget*> _EntryLabelList;
    std::vector<GtkWidget*> _EntryEntryList;
    std::vector<GtkWidget*> _EntryOptionList;
    bool _IsInEntryList;
    bool _IsInButtonList;
    bool _IsInToolBar;
    int _MenuCount, _NotebookCount;
    GtkWidget* _CurrentMenu;
    GtkWidget* _CheckButtonBox;
    GtkWidget* _RadioButtonBox;
    GSList* _RadioButtonGroup;
    TKinokoRadioButtonSetWidget* _RadioButtonSet;
  private:
    void BuildFontNameTable(void);
    PangoFontDescription* LoadFont(std::string FontName, std::string FontSize);
    std::map<std::string, std::string> _PredefinedFontNameTable;
};


#endif
