/* KinokoControlWidgetGtk.hh */
/* Created by Enomoto Sanshiro on 30 September 2001. */
/* Last updated by Enomoto Sanshiro on 30 September 2001. */


#ifndef __KinokoControlWidgetGtk_hh
#define __KinokoControlWidgetGtk_hh


#include <string>
#include <gtk/gtk.h>
#include "KinokoCanvasImageArea.hh"
#include "KinokoControlWidget.hh"


class TKinokoButtonWidgetGtk: public TKinokoButtonWidget {
  public:
    TKinokoButtonWidgetGtk(const std::string& Name, GtkWidget* ButtonWidget, const std::string& ActionOnClick = "");
    virtual ~TKinokoButtonWidgetGtk();
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    GtkWidget* _ButtonWidget;
};


class TKinokoLabelWidgetGtk: public TKinokoLabelWidget {
  public:
    TKinokoLabelWidgetGtk(const std::string& Name, GtkWidget* LabelWidget);
    virtual ~TKinokoLabelWidgetGtk();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    GtkWidget* _LabelWidget;
};


class TKinokoEntryWidgetGtk: public TKinokoEntryWidget {
  public:
    TKinokoEntryWidgetGtk(const std::string& Name, GtkWidget* EntryWidget, GtkWidget* ComboWidget, GList* ComboItemList);
    virtual ~TKinokoEntryWidgetGtk();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual bool SetAttribute(const std::string& Name, const std::string& Value);
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    GtkWidget* _EntryWidget;
    GtkWidget* _ComboWidget;
    GList* _ComboItemList;
};


class TKinokoTextBoxWidgetGtk: public TKinokoTextBoxWidget {
  public:
    TKinokoTextBoxWidgetGtk(const std::string& Name, GtkWidget* TextBoxWidget);
    virtual ~TKinokoTextBoxWidgetGtk();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    GtkWidget* _TextWidget;
};


class TKinokoCheckButtonWidgetGtk: public TKinokoCheckButtonWidget {
  public:
    TKinokoCheckButtonWidgetGtk(const std::string& Name, GtkWidget* CheckButtonWidget);
    virtual ~TKinokoCheckButtonWidgetGtk();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    GtkWidget* _CheckButtonWidget;
};


class TKinokoRadioButtonWidgetGtk: public TKinokoRadioButtonWidget {
  public:
    TKinokoRadioButtonWidgetGtk(const std::string& Name, GtkWidget* RadioButtonWidget);
    virtual ~TKinokoRadioButtonWidgetGtk();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    GtkWidget* _RadioButtonWidget;
};


class TKinokoNotebookWidgetGtk: public TKinokoNotebookWidget {
  public:
    TKinokoNotebookWidgetGtk(const std::string& Name, GtkWidget* NotebookWidget);
    virtual ~TKinokoNotebookWidgetGtk();
    virtual std::string Value(void);
    virtual void SetValue(const std::string& Value);
  protected:
    GtkWidget* _NotebookWidget;
};


class TKinokoMenuItemWidgetGtk: public TKinokoMenuItemWidget {
  public:
    TKinokoMenuItemWidgetGtk(const std::string& Name, GtkWidget* MenuItemWidget, const std::string& ActionOnClick = "");
    virtual ~TKinokoMenuItemWidgetGtk();
    virtual void Enable(void);
    virtual void Disable(void);
  protected:
    GtkWidget* _MenuItemWidget;
};


class TKinokoControlImagePortGtk: public TKinokoControlImagePort {
  public:
    TKinokoControlImagePortGtk(GtkWidget* DrawingAreaWidget);
    virtual ~TKinokoControlImagePortGtk();
    virtual void Initialize(void);
    virtual void Redraw(void);
    virtual TKinokoCanvasImageArea* GetImageArea(void);
  protected:
    GtkWidget* _DrawingAreaWidget;
    TKinokoCanvasImageArea* _ImageArea;
};


#endif
