/* KinokoShellFileSelectDialogGtk.cc */
/* Created by Enomoto Sanshiro on 29 July 2000. */
/* Last updated by Enomoto Sanshiro on 7 January 2010. */


#include <gtk/gtk.h>
#include "MushFileSystem.hh"
#include "KinokoShellFileSelectDialog.hh"
#include "KinokoShellFileSelectDialogGtk.hh"

using namespace std;


TKinokoShellFileSelectDialogGtk::TKinokoShellFileSelectDialogGtk(const string& Title)
: TKinokoShellFileSelectDialog(Title)
{
}

TKinokoShellFileSelectDialogGtk::~TKinokoShellFileSelectDialogGtk()
{
}

string TKinokoShellFileSelectDialogGtk::Open(const string& InitialFileName)
{
    string FileName;

    GtkWidget *Dialog = gtk_file_chooser_dialog_new (
	_Title.c_str(), NULL,
	GTK_FILE_CHOOSER_ACTION_SAVE,
	GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
	NULL
    );

    gtk_file_chooser_set_do_overwrite_confirmation(
	GTK_FILE_CHOOSER(Dialog), FALSE
    );

    if (! InitialFileName.empty()) {
	if (TMushFileAttribute(InitialFileName).IsReadable()) {
	    gtk_file_chooser_set_filename(
		GTK_FILE_CHOOSER(Dialog), InitialFileName.c_str()
	    );
	}
	else {
	    gtk_file_chooser_set_current_name(
		GTK_FILE_CHOOSER(Dialog), InitialFileName.c_str()
	    );
	}
    }

    if (gtk_dialog_run(GTK_DIALOG(Dialog)) == GTK_RESPONSE_ACCEPT) {
	char *CFileName = gtk_file_chooser_get_filename(
	    GTK_FILE_CHOOSER(Dialog)
	);

	string CurrentDirectory = TMushFileSystem().CurrentDirectory();
	if (! CurrentDirectory.empty()) {
	    if (CurrentDirectory[CurrentDirectory.size()-1] != '/') {
		CurrentDirectory += '/';
	    }
	}
	
	if (TMushFileAttribute(CFileName).PathName() == CurrentDirectory) {
	    FileName = TMushFileAttribute(CFileName).FileName();
	}
	else {
	    FileName = CFileName;
	}

	g_free(CFileName);
    }

    gtk_widget_destroy(Dialog);

    return FileName;
}
