/* kcmlcheck.cc */
/* Created by Enomoto Sanshiro on 31 October 2001. */
/* Last updated by Enomoto Sanshiro on 31 October 2001. */


#include <iostream>
#include <fstream>
#include <string>
#include "MushArgumentList.hh"
#include "MushMisc.hh"
#include "KinokoShellConnector.hh"
#include "KinokoControlGtk.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushEnvironmentVariable::Set("LANG", "C");
    TMushEnvironmentVariable::Set("LANGUAGE", "C");
    TMushEnvironmentVariable::Set("LOCALE", "C");

    string KcmlScriptFile;
    string KcsScriptFile;

    TMushArgumentList ArgumentList(argc, argv);
    try {
	ArgumentList.ExpectParameters(1);
	KcmlScriptFile = ArgumentList.ParameterOf(0);
	KcsScriptFile = ArgumentList.ParameterOf(1);
    }
    catch (TSystemCallException& e) {
	cerr << "Usage: " << argv[0] << " SCRIPT_FILE_NAME" << endl;
	return 0;
    }

    TKinokoShellConnector* ShellConnector = new TKinokoConsoleShellConnector();
    ShellConnector->Connect();

    TKinokoControl* Control = new TKinokoControlGtk(ShellConnector, argc, argv);

    Control->Construct(KcmlScriptFile);

    if (! KcsScriptFile.empty()) {
	ifstream ScriptText(KcsScriptFile.c_str());
	if (! ScriptText) {
	    cerr << "ERROR: unable to open file: " << KcsScriptFile << endl;
	}
	else {
	    Control->LoadControlScript(ScriptText);
	}
    }

    Control->Start();

    delete Control;

    return 0;
}
