#! /bin/sh
# smallkinoko.sh
# Created by Sanshiro Enomoto on 9 February 2010


if [ x$KINOKO_ROOT = x ]; then
    echo "ERROR: environment variable KINOKO_ROOT is not defined."
    exit -1
fi

if [ ! -x $KINOKO_ROOT/bin/kinoko-canvas ]; then
    echo "ERROR: Kinoko-GUI subsystem is not available"
    exit -1
fi


SPLASH_DIR="$KINOKO_ROOT/scripts/splash"
MONTH=`date +%m`
case $MONTH in
    12 | 01 | 02)
	SPLASH_FILE="KinokoSplash-2-Winter.png" ;;
    03 | 04 | 05)
	SPLASH_FILE="KinokoSplash-2-Spring.png" ;;
    06 | 07 | 08)
	SPLASH_FILE="KinokoSplash-2-Summer.png" ;;
    09 | 10 | 11)
	SPLASH_FILE="KinokoSplash-2-Fall.png" ;;
esac
if [ x$SPLASH_FILE != x ]; then
    kinoko-splash --time=2000 $SPLASH_DIR/$SPLASH_FILE &
fi


export LANG=C
export LANGUAGE=C
export LOCALE=C


rm -f cleanup.sh
rm -f kinoko-registry.xml

IS_SUCCESS=0
if kcom-manager $KINOKO_ROOT/scripts/SmallKinoko.kcom $*; then
    IS_SUCCESS=1
fi

if [ $IS_SUCCESS = 0 ]; then
    echo
    echo
    echo "### Abnormal Termination Detected ###"
    if [ -r kinoko-registry.xml ]; then
	kinoko-cleanup kinoko-registry.xml > cleanup.sh
	chmod 755 cleanup.sh
	echo "'cleanup.sh' is generated."
    fi
fi
