<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">


<xsl:template match="/KinokoControlPanel">
<html>
  <head>
    <title><xsl:value-of select="@label"/></title>
    <script type="text/javascript" src="kweb-download-kcv.js"></script>
  </head>
  <body bgcolor="white" onload="init()">
    <h3><font color="green"><xsl:value-of select="@label"/></font></h3>
    <form method="post" action="kweb-upload-kcv.cgi">
      <xsl:apply-templates/>
    </form>
  </body>
  </html>
</xsl:template>


<xsl:template match="Label">
  <xsl:element name="div">
    <xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="class">label</xsl:attribute>
    <xsl:value-of select="@label"/>
  </xsl:element>
</xsl:template>

<xsl:template match="Entry">
  <xsl:value-of select="@label"/>: 
  <xsl:element name="input">
    <xsl:attribute name="type">text</xsl:attribute>
    <xsl:attribute name="name">entry:<xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
  </xsl:element>
</xsl:template>

<xsl:template match="Button">
  <xsl:element name="button">
    <xsl:attribute name="type">submit</xsl:attribute>
    <xsl:attribute name="name">button:<xsl:value-of select="@name"/>;on_click:<xsl:value-of select="@on_click"/></xsl:attribute>
    <xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
    <xsl:value-of select="@label"/>
  </xsl:element>
</xsl:template>

<xsl:template match="CheckButton">
  <xsl:element name="input">
    <xsl:attribute name="type">hidden</xsl:attribute>
    <xsl:attribute name="name">check:<xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="value">off</xsl:attribute>
  </xsl:element>
  <xsl:element name="input">
    <xsl:attribute name="type">checkbox</xsl:attribute>
    <xsl:attribute name="name">check:<xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
  </xsl:element>
  <xsl:value-of select="@label"/>
</xsl:template>

<xsl:template match="RadioButton">
  <xsl:element name="input">
    <xsl:attribute name="type">radio</xsl:attribute>
    <xsl:attribute name="name">radio:<xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="id">radiobutton_<xsl:value-of select="@name"/></xsl:attribute>
  </xsl:element>
  <xsl:value-of select="@label"/>
</xsl:template>

<xsl:template match="Frame">
  <h5><xsl:value-of select="@label"/></h5>
  <blockquote>
    <xsl:apply-templates/>
  </blockquote>
</xsl:template>

<xsl:template match="Box">
  <div>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="EntryList">
  <div>
    <xsl:for-each select="Entry">
      <xsl:value-of select="@label"/>: 
      <xsl:element name="input">
        <xsl:attribute name="type">text</xsl:attribute>
        <xsl:attribute name="name">entry:<xsl:value-of select="@name"/></xsl:attribute>
        <xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
      </xsl:element>
      <br/>
    </xsl:for-each>
  </div>
</xsl:template>

<xsl:template match="ButtonList">
  <div>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="CheckButtonList">
  <div>
    <xsl:for-each select="CheckButton">
      <xsl:element name="input">
        <xsl:attribute name="type">hidden</xsl:attribute>
        <xsl:attribute name="name">check:<xsl:value-of select="@name"/></xsl:attribute>
        <xsl:attribute name="value">off</xsl:attribute>
      </xsl:element>
      <xsl:element name="input">
        <xsl:attribute name="type">checkbox</xsl:attribute>
        <xsl:attribute name="name">check:<xsl:value-of select="@name"/></xsl:attribute>
        <xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
      </xsl:element>
      <xsl:value-of select="@label"/>
      <br/>
    </xsl:for-each>
  </div>
</xsl:template>

<xsl:template match="RadioButtonList">
  <xsl:variable name="GroupName"><xsl:value-of select="@name"/></xsl:variable>
  <div>
    <xsl:for-each select="RadioButton">
      <xsl:element name="input">
        <xsl:attribute name="type">radio</xsl:attribute>
        <xsl:attribute name="name">radio:<xsl:value-of select="$GroupName"/></xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
        <xsl:attribute name="id">radiobutton_<xsl:value-of select="@name"/></xsl:attribute>
      </xsl:element>
      <xsl:value-of select="@label"/>
      <br/>
    </xsl:for-each>
  </div>
</xsl:template>


<xsl:template match="NewLine">
  <br/>
</xsl:template>

<xsl:template match="HSpace">
</xsl:template>

<xsl:template match="VSpace">
  <p/>
</xsl:template>

<xsl:template match="Menu"/>
<xsl:template match="Toolbar"/>
<xsl:template match="TextBox"/>
<xsl:template match="Image"/>
<xsl:template match="Constant"/>
<xsl:template match="Script"/>
<xsl:template match="Action"/>

</xsl:stylesheet>
