// web-download-kcv.js //
/* Created by Enomoto Sanshiro on 19 November 2007. */
/* Last updated by Enomoto Sanshiro on 18 April 2007. */


var kcvFile = "control/download-this.kcv";
var updateIntervalSec = 1;

var timer, xhr;
var prevValueList;

function init() {
    var menuForm = parent.menu;
    var modeSelect;
    if (menuForm != null) {
	modeSelect = menuForm.document.getElementById("modeSelect");
    }

    // We keep updating the fields regardless to the mode
    // in order to avoid troubles caused by submission with 
    // inconsistent field values.
    //if ((modeSelect == null) || (modeSelect.selectedIndex != 0)) {
	timer = setInterval(request, 1000 * updateIntervalSec);
    //}

    xhr = new XMLHttpRequest();
    request();
}

function request() {
    xhr.overrideMimeType("text/xml");
    xhr.open("GET", kcvFile + "?date=" + escape(Date()));
    xhr.onreadystatechange = update;
    xhr.send(null);
}

function update() {
    if ((xhr.readyState != 4) || (xhr.status != 200)) {
	return;
    }

    var result = xhr.responseXML;
    var widgetList = result.getElementsByTagName("widget");

    if (widgetList.length > 0) {
	if (prevValueList == null) {
	    prevValueList = new Array(widgetList.length);
	}

	for (var i = 0; i < widgetList.length; i++) {
	    if (widgetList[i].nodeName == "widget") {
		prevValueList[i] = (
		    updateWidget(widgetList[i], prevValueList[i])
		);
	    }
	}
    }
}

function updateWidget(widget, prevValue)
{
    // get remote value //
    var remoteValue;
    if (widget.childNodes.length > 0) {
	remoteValue = widget.firstChild.nodeValue;
    }
    else {
	remoteValue = "";
    }

    // get current value //
    var currentValue;
    var id = widget.getAttribute("name");
    var element = document.getElementById(id);
    if (element == null) {
	id = "radiobutton_" + remoteValue;
	element = document.getElementById(id);
	if ((element == null) || (element.type != "radio")) {
	    return prevValue;
	}
    }
    if (element.type == "text") {
	currentValue = element.value;
    }
    else if (element.type == "checkbox") {
	currentValue = element.checked ? "1" : "0";
    }
    else if (element.type == "radio") {
	currentValue = remoteValue;
	if (! element.checked) {
	    var radioList = document.getElementsByName(element.name);
	    for (var j = 0; j < radioList.length; j++) {
		if (radioList[j].checked) {
		    currentValue = radioList[j].value;
		    break;
		}
	    }
	}
    }
    else if (element.className == "label") {
	currentValue = element.innerHTML;
    }
    else if (element.type == "submit") {
	currentValue = remoteValue;
    }

    // choose new value and new status //
    var newValue, newStatus;
    if (prevValue == null) {
	prevValue = currentValue;
    }
    if ((currentValue != prevValue) && (currentValue != remoteValue)) {
	newValue = currentValue;
	if (prevValue == remoteValue) {
	    newStatus = "local_changed";
	}
	else {
	    newStatus = "confilicted";
	}
    }
    else {
	newValue = remoteValue;
	prevValue = newValue;
	if (currentValue != remoteValue) {
	    newStatus = "remote_changed";
	}
	else {
	    newStatus = "unchanged";
	}
    }

    // set new value //
    if (element.type == "text") {
	element.value = newValue;
    }
    else if (element.type == "checkbox") {
	element.checked = (newValue == "1");
    }
    else if (element.type == "radio") {
	element.checked = (newValue == remoteValue);
    }
    else if (element.className == "label") {
	element.innerHTML = newValue;
    }
    else if (element.type == "submit") {
	if (widget.getAttribute("status") == "disabled") {
	    element.style.color = "lightgray";
	    element.onclick = function() { return false; }
	}
	else {
	    element.style.color = "black";
	    element.onclick = function() { return true; }
	}
    }
    
    // set status color //
    if (newStatus == "local_changed") {
	element.style.backgroundColor = "yellow";
    }
    else if (newStatus == "remote_changed") {
	//element.style.backgroundColor = "orange";
    }
    else if (newStatus == "conflicted") {
	element.style.backgroundColor = "red";
    }
    else {
	element.style.backgroundColor = "white";
    }

    return prevValue;
}
