#! /usr/bin/perl -wT

use strict;

my $query = $ENV{'QUERY_STRING'};

my ($file, $type);
if ($query =~ m/file=([^&]+)/) {
    $file = $1;
}
else {
    die "file not specified: query=\"$query\"\n";
}
if ($query =~ m/type=([^&]+)/) {
    $type = $1;
}
else {
    die "type not specified: query=\"$query\"\n";
}

if ($file =~ m/[\/\\]/) {
    die "invalid file specified: query=\"$query\"\n";
}

open(FILE, $file) or die "unable to open file: \"$file\"\n";

if ($query =~ m/mode=binary/) {
    binmode FILE;
    binmode STDOUT;
}

print("Content-type: $type\n\n");
print while (<FILE>);

close(FILE);
