#! /usr/bin/perl
# genscript-kinoko-hist.pl
# Created by Sanshiro Enomoto on 16 February 2008.


($script_file, $data_file, $hist_min, $hist_max, $hist_nbin, $channel_list) = @ARGV;
($hist_nbin ne "") or die "Usage: genscript-kinoko-hist SCRIPT_FILE DATA_FILE HIST_MIN HIST_MAX HIST_NBIN [CHANNEL_LIST]\n";


@data_path_list = split(/\//, $data_file);
$data_file_name = @data_path_list[$#data_path_list];

@script_path_list = split(/\//, $script_file);
$script_file_name = @script_path_list[$#script_path_list];
($data_name = $script_file_name) =~ s/\.\w+$//;

foreach $channel (split(/,/, $channel_list)) {
    $channel_flags{$channel} = "1";
}


open(DATA_FILE, $data_file) or die "unable to open $data_file\n";
while (<DATA_FILE>) {
    chop($_);
    if (/^#\s*Fields\s*:\s*(.*)/) {
	@field_list = split(/\s+/, $1);
	last;
    }
}
close(DATA_FILE);

($script = <<EOF)
    :// $script_file
    :// KinokoViewer script for '$data_file_name'.
    :// Generated automatically from $data_file by 'genscript-kinoko-hist'.
    :
    :display $data_name
    :{
    :    %CREATE_HISTS%
    :
    :    analysis {
    :        %DECLARE_FIELDS%
    :
    :        %FILL_HISTS%
    :    }
    :
    :    on every (1 sec) {
    :        %DRAW_HISTS%
    :    }
    :}
EOF
    =~ s/[ \t]*://sg;

$create_hists = "";
$declare_fields = "";
$fill_hists = "";
$draw_hists = "";
$indent = "    ";

$index = 0;
foreach $field_name (@field_list) {
    if (($field_name eq "index") or ($field_name eq "time")) {
        next;
    }

    $field_name =~ /([^\.]+)\.([^\.]+)/;
    $section_name = $1;
    $channel_name = $2;

    if (($channel_list ne "") and ($channel_flags{$channel_name} ne "1")) {
	next;
    }

    $create_hists .= (
        "$indent" .
	"Histogram h_$index(\"$field_name\", $hist_nbin, $hist_min, $hist_max);\n"
    );
    $declare_fields .= (
        "$indent" . "$indent" .
        "DataElement data_$index(\"$section_name\", $channel_name);\n"
    );
    $fill_hists .= "$indent" . "$indent" . "h_$index.fill(data_$index);\n";
    $draw_hists .= "$indent" . "$indent" . "h_$index.draw();\n";

    $index++;
}

$script =~ s/[ \t]*%CREATE_HISTS%[ \t]*\n/$create_hists/;
$script =~ s/[ \t]*%DECLARE_FIELDS%[ \t]*\n/$declare_fields/;
$script =~ s/[ \t]*%FILL_HISTS%[ \t]*\n/$fill_hists/;
$script =~ s/[ \t]*%DRAW_HISTS%[ \t]*\n/$draw_hists/;

open(SCRIPT_FILE, "> $script_file") or die "unable to create $script_file.";
print SCRIPT_FILE $script;
close SCRIPT_FILE;
