/* ksysinfo.cc */
/* Created by Enomoto Sanshiro on 27 September 2002. */
/* Last updated by Enomoto Sanshiro on 27 September 2002. */


#include <iostream>
#include <string>
#include "MushMisc.hh"
#include "MushNetworkSocket.hh"
#include "MushIpc.hh"
#include "MushFileSystem.hh"


using namespace std;


int main(void)
{
    TMushLocalHost Host;
    cout << "date: " << TMushDateTime().AsString() << endl;
    cout << "host: " << Host.HostName();
    cout << " (" << Host.Machine() << ", ";
    cout << Host.SystemName() << " ";
    cout << Host.SystemRelease() << ")" << endl;
    cout << endl;

    cout << "Network Configuration:" << endl;
    cout << "\thostname: " << TMushNetworkSocket::LocalHostName() << endl;
    cout << "\taddress: " << TMushNetworkSocket::LocalIPAddress() << endl;
    try {
        string LocalHostIP = TMushNetworkSocket::AddressStringOf(TMushNetworkSocket::HostAddressByName("localhost"));
	cout << "\tlocalhost address: " << LocalHostIP << endl;
    }
    catch (TSystemCallException &e) {
        cout << "\tlocalhost address: unable to find host 'localhost'" << endl;
    }
    cout << endl;

    cout << "IPC Resources:" << endl;
    cout << "\tmax shared memory size: (not implemented yet)" << endl;
    cout << "\tmessage queue capacity: (not implemented yet)" << endl;
    cout << endl;

    string CurrentDirectory = TMushFileSystem::CurrentDirectory();
    TMushFileSystem FileSystem(CurrentDirectory);
    cout << "File System [" << CurrentDirectory << "]:" << endl;
    cout << "\ttype: 0x" << hex << FileSystem.FileSystemType() << dec << endl;
    cout << "\tblocksize: " << FileSystem.BlockSize() << endl;
    cout << "\ttotal blocks: " << FileSystem.TotalNumberOfBlocks() << endl;
    cout << "\tfree blocks: " << FileSystem.NumberOfFreeBlocks() << endl;
    cout << "\tavailable blocks: " << FileSystem.NumberOfAvailableBlocks() << endl;
    cout << "\ttotal nodes: " << FileSystem.TotalNumberOfNodes() << endl;
    cout << "\tfree nodes: " << FileSystem.NumberOfFreeNodes() << endl;
    cout << endl;
    
    return 0;
}
